'''OpenGL extension EXT.texture_sRGB

Overview (from the spec)
	
	Conventional texture formats assume a linear color space.  So for
	a conventional internal texture format such as GL_RGB8, the 256
	discrete values for each 8-bit color component map linearly and
	uniformly to the [0,1] range.
	
	The sRGB color space is based on typical (non-linear) monitor
	characteristics expected in a dimly lit office.  It has been
	standardized by the International Electrotechnical Commission (IEC)
	as IEC 61966-2-1. The sRGB color space roughly corresponds to 2.2
	gamma correction.
	
	This extension adds a few new uncompressed and compressed color
	texture formats with sRGB color components.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/texture_sRGB.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_SRGB_EXT = constant.Constant( 'GL_SRGB_EXT', 0x8C40 )
GL_SRGB8_EXT = constant.Constant( 'GL_SRGB8_EXT', 0x8C41 )
GL_SRGB_ALPHA_EXT = constant.Constant( 'GL_SRGB_ALPHA_EXT', 0x8C42 )
GL_SRGB8_ALPHA8_EXT = constant.Constant( 'GL_SRGB8_ALPHA8_EXT', 0x8C43 )
GL_SLUMINANCE_ALPHA_EXT = constant.Constant( 'GL_SLUMINANCE_ALPHA_EXT', 0x8C44 )
GL_SLUMINANCE8_ALPHA8_EXT = constant.Constant( 'GL_SLUMINANCE8_ALPHA8_EXT', 0x8C45 )
GL_SLUMINANCE_EXT = constant.Constant( 'GL_SLUMINANCE_EXT', 0x8C46 )
GL_SLUMINANCE8_EXT = constant.Constant( 'GL_SLUMINANCE8_EXT', 0x8C47 )
GL_COMPRESSED_SRGB_EXT = constant.Constant( 'GL_COMPRESSED_SRGB_EXT', 0x8C48 )
GL_COMPRESSED_SRGB_ALPHA_EXT = constant.Constant( 'GL_COMPRESSED_SRGB_ALPHA_EXT', 0x8C49 )
GL_COMPRESSED_SLUMINANCE_EXT = constant.Constant( 'GL_COMPRESSED_SLUMINANCE_EXT', 0x8C4A )
GL_COMPRESSED_SLUMINANCE_ALPHA_EXT = constant.Constant( 'GL_COMPRESSED_SLUMINANCE_ALPHA_EXT', 0x8C4B )
GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = constant.Constant( 'GL_COMPRESSED_SRGB_S3TC_DXT1_EXT', 0x8C4C )
GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = constant.Constant( 'GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT', 0x8C4D )
GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = constant.Constant( 'GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT', 0x8C4E )
GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = constant.Constant( 'GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT', 0x8C4F )


def glInitTextureSrgbEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_EXT_texture_sRGB' )
