'''OpenGL extension SGIX.texture_coordinate_clamp

Overview (from the spec)
	
	This extension provides a mechanism to specify the maximum texture coordinate
	clamping values. Standard OpenGL always clamps the upper bound to 1.0 when
	the wrap mode is set to CLAMP. This mechanism can be used to  guarantee 
	that non-existent texel data will not be accessed when the texture image has 
	dimensions that are not a power of 2.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SGIX/texture_coordinate_clamp.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_TEXTURE_MAX_CLAMP_S_SGIX = constant.Constant( 'GL_TEXTURE_MAX_CLAMP_S_SGIX', 0x8369 )
GL_TEXTURE_MAX_CLAMP_T_SGIX = constant.Constant( 'GL_TEXTURE_MAX_CLAMP_T_SGIX', 0x836A )
GL_TEXTURE_MAX_CLAMP_R_SGIX = constant.Constant( 'GL_TEXTURE_MAX_CLAMP_R_SGIX', 0x836B )


def glInitTextureCoordinateClampSGIX():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_SGIX_texture_coordinate_clamp' )
