#import sys
import warnings
import unittest
from tables import *
import numarray

from test_all import verbose, cleanup, allequal
# To delete the internal attributes automagically
unittest.TestCase.tearDown = cleanup

# Check read Tables from pytables version 0.5 (ucl-nrv2e), and 0.7 (ucl-nvr2d)
class BackCompatTablesTestCase(unittest.TestCase):

    #----------------------------------------

    def test01_readTable(self):
        """Checking backward compatibility of old formats of tables"""

        if verbose:
            print '\n', '-=' * 30
            print "Running %s.test01_readTable..." % self.__class__.__name__

        # Create an instance of an HDF5 Table
        warnings.filterwarnings("ignore", category=UserWarning)
        self.fileh = openFile(self.file, "r")
        warnings.filterwarnings("default", category=UserWarning)

        table = self.fileh.getNode("/tuple0")

        # Read the 100 records
        result = [ rec['var2'] for rec in table]
        if verbose:
            print "Nrows in", table._v_pathname, ":", table.nrows
            print "Last record in table ==>", rec
            print "Total selected records in table ==> ", len(result)

        assert len(result) == 100
        self.fileh.close()

class Table1_0UCL(BackCompatTablesTestCase):
    file = "Table1_0_ucl_nrv2e.h5"  # pytables 0.5.1 and before

class Table2_0UCL(BackCompatTablesTestCase):
    file = "Table2_0_ucl_nrv2d.h5"  # pytables 0.7.x versions

class Table2_1UCL(BackCompatTablesTestCase):
    file = "Table2_1_ucl_nrv2e_shuffle.h5"  # pytables 0.8.x versions and after

class Tables_LZO1(BackCompatTablesTestCase):
    file = "Tables_lzo1.h5"  # files compressed with LZO1

class Tables_LZO1_shuffle(BackCompatTablesTestCase):
    file = "Tables_lzo1_shuffle.h5"  # files compressed with LZO1 and shuffle

class Tables_LZO2(BackCompatTablesTestCase):
    file = "Tables_lzo2.h5"  # files compressed with LZO2

class Tables_LZO2_shuffle(BackCompatTablesTestCase):
    file = "Tables_lzo2_shuffle.h5"  # files compressed with LZO2 and shuffle

# Check read attributes from PyTables >= 1.0 properly
class BackCompatAttrsTestCase(unittest.TestCase):
    file = "zerodim-attrs-%s.h5"

    def test01_readAttr(self):
        """Checking backward compatibility of old formats for attributes"""

        if verbose:
            print '\n', '-=' * 30
            print "Running %s.test01_readAttr..." % self.__class__.__name__

        # Read old formats
        self.fileh = openFile(self.file % self.format, "r")
        a = self.fileh.getNode("/a")
        scalar = numarray.array(1, type="Int32")
        vector = numarray.array([1], type="Int32")
        if self.format == "1.3":
            assert allequal(a.attrs.arrdim1, vector)
            assert allequal(a.attrs.arrscalar, scalar)
            assert a.attrs.pythonscalar == 1
        elif self.format == "1.4":
            assert allequal(a.attrs.arrdim1, vector)
            assert allequal(a.attrs.arrscalar, scalar)
            assert allequal(a.attrs.pythonscalar, scalar)

        self.fileh.close()

class Attrs_1_3(BackCompatAttrsTestCase):
    format = "1.3"    # pytables 1.0.x versions and earlier

class Attrs_1_4(BackCompatAttrsTestCase):
    format = "1.4"    # pytables 1.1.x versions and later


#----------------------------------------------------------------------

def suite():
    theSuite = unittest.TestSuite()
    niter = 1

    #theSuite.addTest(unittest.makeSuite(Table1_0UCL))
    #theSuite.addTest(unittest.makeSuite(Table2_0UCL))
    #theSuite.addTest(unittest.makeSuite(Table2_1UCL))

    ucl_avail = whichLibVersion("ucl") is not None
    for n in range(niter):
        if ucl_avail:
            theSuite.addTest(unittest.makeSuite(Table1_0UCL))
            theSuite.addTest(unittest.makeSuite(Table2_0UCL))
            theSuite.addTest(unittest.makeSuite(Table2_1UCL))
            theSuite.addTest(unittest.makeSuite(Tables_LZO1))
            theSuite.addTest(unittest.makeSuite(Tables_LZO1_shuffle))
            theSuite.addTest(unittest.makeSuite(Tables_LZO2))
            theSuite.addTest(unittest.makeSuite(Tables_LZO2_shuffle))
            theSuite.addTest(unittest.makeSuite(Attrs_1_3))
            theSuite.addTest(unittest.makeSuite(Attrs_1_4))

    return theSuite


if __name__ == '__main__':
    unittest.main( defaultTest='suite' )
