import os
from distutils.command import build_py
from distutils.dep_util import newer

class BuildPy(build_py.build_py):

    command_name = 'build_py'
    
    def finalize_options(self):
        build_py.build_py.finalize_options(self)

        self.config_filename = None
        if self.distribution.config_module:
            parts = self.distribution.config_module.split('.')
            self.config_filename = os.path.join(self.build_lib, *parts) + '.py'
        return

    def run(self):
        build_py.build_py.run(self)

        config = self.get_finalized_command('config')
        if (not self.dry_run and
            (self.config_filename and
             newer(config.cache_filename, self.config_filename))):
            # Create the configuration filename
            self.announce('creating ' + self.config_filename)
            config_vars = config.get_config_vars()

            names = config_vars.keys()
            names.sort()
            maxlen = max(map(len, names))
            
            f = open(self.config_filename, 'w')
            f.write('# Configuration variables\n')
            for name in names:
                value = config_vars[name]
                f.write('%-*s = %r\n' % (maxlen, name.upper(), value))
            f.close()
        return

    def get_outputs(self, include_bytecode=1):
        outputs = build_py.build_py.get_outputs(self, include_bytecode)
        if self.config_filename:
            outputs.append(self.config_filename)
        return outputs
