########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Lib/Terminfo.py,v 1.1 2002/12/05 23:23:12 jkloth Exp $
"""
Provides some of the information from the terminfo database.

Copyright 2002 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__revision__ = "$Id: Terminfo.py,v 1.1 2002/12/05 23:23:12 jkloth Exp $"

import sys, os

TERMTYPES = ['linux', 'console', 'con132x25', 'con132x30', 'con132x43',
             'con132x60', 'con80x25', 'con80x28', 'con80x30', 'con80x43',
             'con80x50', 'con80x60', 'xterm', 'xterm-color', 'color-xterm',
             'vt100', 'rxvt', 'ansi', 'Eterm',
             ]

# Default sizes should fit on all displays.
DEFAULT_LINES = 24
DEFAULT_COLUMNS = 80

def GetLines(stream=sys.stdout):
    lines = DEFAULT_LINES
    if stream.isatty() and os.environ.get('TERM') in TERMTYPES:
        try:
            import fcntl, termios, struct
        except ImportError:
            pass
        else:
            if hasattr(termios, 'TIOCGWINSZ'):
                ws = struct.pack("HHHH", 0, 0, 0, 0)
                ws = fcntl.ioctl(stream.fileno(), termios.TIOCGWINSZ, ws)
                lines, columns, x, y = struct.unpack("HHHH", ws)
    return lines

def GetColumns(stream=sys.stdout):
    columns = DEFAULT_COLUMNS
    if stream.isatty() and os.environ.get('TERM') in TERMTYPES:
        try:
            import fcntl, termios, struct
        except ImportError:
            pass
        else:
            if hasattr(termios, 'TIOCGWINSZ'):
                ws = struct.pack("HHHH", 0, 0, 0, 0)
                ws = fcntl.ioctl(stream.fileno(), termios.TIOCGWINSZ, ws)
                lines, columns, x, y = struct.unpack("HHHH", ws)
    return columns


def GetColors(stream=sys.stdout):
    if stream.isatty() and os.environ.get('TERM') in TERMTYPES:
        return AnsiColors
    else:
        return NoColors
    return


# ISO 6429 color sequences are composed of sequences of numbers
# separated by semicolons.  The most common codes are:
#
#          0     to restore default color
#          1     for brighter colors
#          4     for underlined text
#          5     for flashing text
#         30     for black foreground
#         31     for red foreground
#         32     for green foreground
#         33     for yellow (or brown) foreground
#         34     for blue foreground
#         35     for purple foreground
#         36     for cyan foreground
#         37     for white (or gray) foreground
#         40     for black background
#         41     for red background
#         42     for green background
#         43     for yellow (or brown) background
#         44     for blue background
#         45     for purple background
#         46     for cyan background
#         47     for white (or gray) background

class AnsiColors:
    
    NORMAL = '\033[0m'
    GRAY = '\033[1;30m'
    RED = '\033[1;31m'
    GREEN = '\033[1;32m'
    BROWN = '\033[0;33m'
    YELLOW = '\033[1;33m'
    WHITE = '\033[1;37m'

class NoColors:
    pass

for color in dir(AnsiColors):
    setattr(NoColors, color, '')
del color
