########################################################################
#
# File Name: 	       Constant.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Constant.py.html
#
"""
Implements the Constant meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import MetaObject

from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Constant(MetaObject.MetaObject):
    def __init__(self,db,data):
        MetaObject.MetaObject.__init__(self,db,data,MetaKind.mk_constant)

    def value(self):
        if self.the_Value:
            return self.the_Value.value()
        return None

    def form_the_Value(self,target,inverse=1):
        from Ft.Ods.MetaData import Operand
        self._4ods_formRelationship('the_Value',Operand.Operand,'value_of','form',target,inverse)

    def drop_the_Value(self,target,inverse=1):
        self._4ods_dropRelationship('the_Value','value_of','drop',target,inverse)

    def form_type(self,target,inverse = 1):
        from Ft.Ods.MetaData import Type
        self._4ods_formRelationship('type',Type.Type,'constants','add',target,inverse)

    def drop_type(self,target,inverse=1):
        self._4ods_dropRelationship('type','constants','remove',target,inverse)

    def add_referenced_by(self,target,inverse=1):
        from Ft.Ods.MetaData import ConstOperand
        self._4ods_addRelationship('referenced_by',ConstOperand.ConstOperand,'references','form',target,inverse)
    form_referenced_by=add_referenced_by

    def remove_referenced_by(self,target,inverse=1):
        self._4ods_removeRelationship('referenced_by','references','drop',target,inverse)
    drop_referenced_by=remove_referenced_by

    def form_enumeration(self,target,inverse = 1):
        from Ft.Ods.MetaData import Enumeration
        self._4ods_formRelationship('enumeration',Enumeration.Enumeration,'elements','add',target,inverse)

    def drop_enumeration(self,target,inverse=1):
        self._4ods_dropRelationship('enumeration','elements','remove',target,inverse)



    def _4ods_getOdl(self,indent):
        st = indent + 'const %s %s = %s' % (self.type._4ods_getOdl(''),self.name,self.the_Value._4ods_getOdl(''))
        return st

    def _4ods_checkRemove(self):
        return 1

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)
        found.append(self)
        self.type._4ods_getGeneratedMetaClasses(found,checked)

    def _4ods_findTypePath(self,object):
        if self.type == object:
            res = [object]
        else:
            res = self.type._4ods_findTypePath(object)
        if res:
            return [self] + res
        return []



    _tupleNames = (('the_Value',),('type',),('referenced_by',),('enumeration',))

    _tupleDefinitions = {'the_Value':{td.TYPE:Constants.Types.ROBJECT,
                                      td.READONLY:1,
                                      td.RELATIONSHIP:1,
                                      },
                         'type':{td.TYPE:Constants.Types.ROBJECT,
                                 td.RELATIONSHIP:1,
                                 td.READONLY:1,
                                 },
                         'referenced_by':{td.TYPE:Constants.Types.SET_COLLECTION,
                                          td.RELATIONSHIP:1,
                                          td.READONLY:1,
                                          td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                          },
                         'enumeration':{td.TYPE:Constants.Types.ROBJECT,
                                        td.RELATIONSHIP:1,
                                        td.READONLY:1,
                                        },
                         }
    

    _localExtents = ()

