########################################################################
#
# File Name: 	        PrimitiveType.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/PrimitiveType.py.html
#
"""
Implements the Type meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.MetaData import Type
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.MetaData import PrimitiveKind
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.PersistentObject import TupleDefinitions
td = TupleDefinitions

from Ft.Ods.Exception import FtodsUnknownError


g_nameToOdlMap = {'pk_boolean' : 'boolean',
                  'pk_char' : 'char',
                  'pk_string' : 'string',
                  'pk_short' : 'short',
                  'pk_ushort' : 'unsigned short',
                  'pk_date' : 'date',
                  'pk_time' : 'time',
                  'pk_timestamp' : 'timestamp',
                  'pk_long' : 'long',
                  'pk_ulong' : 'unsigned long',
                  'pk_long_long' : 'long long',
                  'pk_float' : 'float',
                  'pk_double' : 'double',
                  'pk_octet' : 'octet',
                  'pk_interval' : 'interval',
                  'pk_void' : 'void',
                  'pk_blob' : 'blob'
                  }
g_nameToOdlType = {
    0:Constants.Types.BOOLEAN,
    1:Constants.Types.CHAR,
    2 : Constants.Types.STRING,
    3:Constants.Types.SIGNED_SHORT,
    4:Constants.Types.UNSIGNED_SHORT,
    5:Constants.Types.DATE,
    6:Constants.Types.TIME,
    7:Constants.Types.TIMESTAMP,
    8:Constants.Types.SIGNED_LONG,
    9:Constants.Types.UNSIGNED_LONG,
    10:Constants.Types.SIGNED_LONG_LONG,
    11: Constants.Types.FLOAT, 
    12:Constants.Types.DOUBLE,
    13:Constants.Types.OCTET,
    14:Constants.Types.INTERVAL,
    15:Constants.Types.VOID,
    16:Constants.Types.BLOB
    }


class PrimitiveType(Type.Type):

    def __init__(self,db,data,pk=None):
        Type.Type.__init__(self,db,data,MetaKind.mk_primitive_type)
        if data is None:
            if pk is None:
                raise FtodsUnknownError(msg="No primtive kind specified")
            self.__dict__['primitive_kind'] = pk


    def absolute_name(self):
        return g_nameToOdlMap[self.name]
        

    def _4ods_getOdmgType(self):
        return g_nameToOdlType[self.primitive_kind._v]

    
    def _4ods_getOdl(self,indent):
        return indent + g_nameToOdlMap[self.name]

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)

    def _4ods_findTypePath(self,object):
        return []


    _tupleNames = (('primitive_kind',),)
    _tupleDefinitions = {'primitive_kind':{td.TYPE:Constants.Types.ENUMERATION,
                                           td.READONLY:1,
                                           td.LITERAL_REPO_ID:PrimitiveKind.PrimitiveKind._typeId,
                                           },
                         }

    _localExtents = ()


