########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/MessageSource.py,v 1.20 2004/07/10 05:55:12 cogbuji Exp $
"""
Misc error codes and messages for the repository servers

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft import TranslateMessage as _

class Error:
    INTERNAL_ERROR = 1
    TRANSACTION_IN_PROGRESS = 2
    TRANSACTION_NOT_IN_PROGRESS = 3
    INVALID_SESSION = 4

    CONFIG_NOT_FOUND = 10
    CONFIG_MISSING_PROPERTY = 11
    CONFIG_MULTIPLE_PROPERTIES = 12
    CONFIG_INVALID_VALUE = 13
    CONFIG_FILE_MISSING = 14
    CONFIG_INVALID_CORE_ID = 15
    CONFIG_INVALID_REPOSITORY = 16
    UNKNOWN_DRIVER_ERROR = 17
    DRIVER_UNAVAILABLE = 18

    INVALID_PATH = 20
    UNKNOWN_PATH = 21
    INVALID_LOGIN = 22
    PATH_EXISTS = 23
    UNKNOWN_RESOURCE_TYPE = 24
    UNSUPPORTED_FTSS_URI_SCHEME = 25
    RELATIVE_PATH_IN_FTSS_URI = 26
    RELATIVE_PATH_FOR_FTSS_URI = 27
    NO_REMOTE_REPO_ACCESS = 28
    #URI version of UNKNOWN_PATH
    RESOURCE_NOT_FOUND = 29

    BROKEN_ALIAS = 30
    OBJECT_DELETED = 31
    PERMISSION_DENIED = 32
    INVALID_ACL_IDENT = 33
    USER_EXISTS = 34
    GROUP_EXISTS = 35

    XML_PARSE_EXCEPTION = 40
    XSLT_PARSE_EXCEPTION = 41
    USER_XSLT_DOCDEF_EXCEPTION = 42

    UNKNOWN_SERVER = 50
    NOT_SUPPORTED = 51
    UNKNOWN_RPC_COMMAND = 52

    LOG_URIREF_MISSING = 60

    UNABLE_TO_INITALIZE_REPO = 100

    INVALID_XML = 1000
    VALIDATION_ERROR = 1001
    UNKNOWN_VALIDATION_TYPE = 1010

    SWISH_NOT_SUPPORTED = 2000

    EXTENSION_MISSING_REQUIRED_ATTRIBUTE = 2500

    ALREADY_GROUP_MEMBER = 3000


g_errorMessages = {
    Error.INTERNAL_ERROR: _('There is an internal bug in 4Suite. '
        'Please make a post to the 4Suite mailing list to report this error '
        'message to the developers. Include platform details and info about '
        'how to reproduce the error. Info about the mailing list is at '
        'http://lists.fourthought.com/mailman/listinfo/4suite. '
        'The error code to report is: %s'),
    Error.TRANSACTION_IN_PROGRESS: _('Transaction already in progress'),
    Error.TRANSACTION_NOT_IN_PROGRESS: _('Transaction not in progress'),
    Error.INVALID_SESSION: _("Your session ID is invalid"),

    Error.CONFIG_NOT_FOUND: _('Unable to find configuration file.  Please '
                              'set FTSERVER_CONFIG_FILE in your environment.'),
    Error.CONFIG_MISSING_PROPERTY: _('Missing required configuration property '
                                     '%(property)s.  Please specify in the '
                                     'configuration file'),
    Error.CONFIG_MULTIPLE_PROPERTIES: _('Multiple configuration properties: '
                                        '%(property)s'),
    Error.CONFIG_INVALID_VALUE : _('Property %(property)s has invalid value '
                                   '%(reason)s'),
    Error.CONFIG_FILE_MISSING: _('Unable to find configuration file %(file)s.'),
    Error.CONFIG_INVALID_CORE_ID: _('Invalid Core ID \'%(name)s\'. Make sure '
                                    'config file has rdf:ID on Core element.'),
    Error.CONFIG_INVALID_REPOSITORY: _('The Repository either does not exist or '
                                       'is misconfigured.  Please see '
                                       '4ss_manager init --help for details..'),

    Error.UNKNOWN_DRIVER_ERROR: _('Driver type %(driver)r is unknown.'),
    Error.DRIVER_UNAVAILABLE : _('Driver %(driver)r is unavailable.\n'
                                 '%(reason)s'),


    Error.UNKNOWN_PATH: _('Path %(path)s is unknown'),
    Error.RESOURCE_NOT_FOUND: _('No resource found with ID %(uri)s'),
    Error.INVALID_PATH: _('Path %(path)s is not of type %(type)s'),
    Error.PATH_EXISTS: _('Path %(path)s is already in the repository'),
    Error.INVALID_LOGIN: _('Invalid Login'),
    Error.UNKNOWN_RESOURCE_TYPE: _('Resource Type %(type)s is unknown'),
    Error.UNSUPPORTED_FTSS_URI_SCHEME: _('URI %(uri)s cannot be converted '
                                         'to a repo (%(ftssScheme)s) URI.'),
    Error.RELATIVE_PATH_IN_FTSS_URI: _('Repo path cannot be obtained '
                                       'from URI %(uri)s because the '
                                       'path part of the URI appears '
                                       'to be relative to an unknown '
                                       'base. Use a URI with scheme '
                                       '%(ftssScheme)s and an '
                                       'absolute path.'),
    Error.RELATIVE_PATH_FOR_FTSS_URI: _('The relative path %(path)s '
                                        'cannot be converted to a '
                                        '%(ftssScheme)s URI. Use an '
                                        'absolute path.'),
    Error.NO_REMOTE_REPO_ACCESS: _('Remote repo access unsupported. '
                                   'The URI attempted was %(uri)s'),

    Error.BROKEN_ALIAS: _('Alias %(path)s is broken'),
    Error.OBJECT_DELETED: _('Object %(path)s has been deleted'),
    Error.PERMISSION_DENIED: _("You do not have '%(level)s' access to %(path)s"),
    Error.INVALID_ACL_IDENT: _("ACL identifier %(aclIdent)s is unrecognized."),
    Error.USER_EXISTS: _("The user name '%(userName)s' already exists in the repository."),
    Error.GROUP_EXISTS: _("The group name '%(groupName)s' already exists in the repository."),


    Error.XML_PARSE_EXCEPTION: _("Xml Parse Exception: %(message)s"),
    Error.XSLT_PARSE_EXCEPTION: _("Xslt Parse Exception: %(message)s"),
    
    Error.USER_XSLT_DOCDEF_EXCEPTION: _("Exception executing a user-defined xslt document definition transformation "),

    Error.UNKNOWN_SERVER : _("Unknown protocol server: %(server)s"),
    Error.NOT_SUPPORTED : _('Requested operation not supported: %(reason)s'),
    Error.UNKNOWN_RPC_COMMAND : _("The RPC command '%(cmd)s' was not recognized."),

    Error.LOG_URIREF_MISSING: _('The logfile URI reference %(path)s was not found in the repository'),

    Error.INVALID_XML : _("The XML is not in proper format: %(msg)s"),

    Error.UNKNOWN_VALIDATION_TYPE : _("The validation type %(type)s is unknown"),


    Error.VALIDATION_ERROR : _('Validation Error: %(message)s'),

    Error.SWISH_NOT_SUPPORTED : _("Text indexing with swish is not supported: %(reason)s"),

    Error.EXTENSION_MISSING_REQUIRED_ATTRIBUTE : _("Extension Element %(element)s missing required attribute %(name)s"),

    Error.ALREADY_GROUP_MEMBER : _('%(userName)s is already a member of group %(groupName)s.'),
    Error.UNABLE_TO_INITALIZE_REPO : _('Unable to initialize the repository: %(msg)s'),
    #Error. : _(''),

}

