########################################################################
#
# File Name:            Documentdefinition.py
#
"""
XSLT and XPath extensions supporting the 4SS documentdefinition API
WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ns import SCORE_NS
import FtssXsltBase
from Ft.Xml.XPath import Conversions
from Ft.Server.Common import CreationParams

from Ft.Xml.Xslt import XsltElement
from Ft.Xml.Xslt import ContentInfo, AttributeInfo
from Ft.Xml.Xslt import OutputParameters
import cStringIO


class AddBaseDocumentDefinitionElement(XsltElement):
    """
    Add a new document definition to a document definitions base defs.
    """

    content = None

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(default=None,
					       description='The path of the document'),
        'docdef' : AttributeInfo.UriReferenceAvt(required=1,
						 description='The document definition to use'),
        }

    childArgument = None

    def __init__(self, root, namespaceUri, localName, baseUri):
        XsltElement.__init__(self, root, namespaceUri, localName, baseUri)
        return

    def instantiate(self, context, processor):
        context.setProcessState(self)

        path = self._path.evaluate(context)
        dd = self._docdef.evaluate(context)

        base = FtssXsltBase.FetchBaseObject(processor, path)
	docdef = FtssXsltBase.FetchBaseObject(processor, dd)

	base.addBaseDocumentDefinition(docdef);

        return (context,)


def GetCreationParams(context, path=None):
    path = Conversions.StringValue(path)
    base = FtssXsltBase.FetchBaseObject(context.processor, path)

    cp = base.getCreationParams()
    doc = CreationParams.Serialize(cp)
    return [doc]

def GetBaseDefinitions(context, path=None):
    path = Conversions.StringValue(path)
    base = FtssXsltBase.FetchBaseObject(context.processor, path)

    proc = context.processor
    proc.pushResultTree(base.getAbsolutePath())
    for path in base.getBaseDefinitions():        
        proc.writers[-1].startElement('BaseDocumentDefinition')
        proc.writers[-1].text(path.getAbsolutePath())
        proc.writers[-1].endElement('BaseDocumentDefinition')

    return proc.popResult().childNodes

def GetDerivedDefinitions(context, path=None):
    path = Conversions.StringValue(path)
    base = FtssXsltBase.FetchBaseObject(context.processor, path)

    proc = context.processor
    proc.pushResultTree(base.getAbsolutePath())
    for path in base.getDerivedDefinitions():        
        proc.writers[-1].startElement('DerivedDocumentDefinition')
        proc.writers[-1].text(path.getAbsolutePath())
        proc.writers[-1].endElement('DerivedDocumentDefinition')

    return proc.popResult().childNodes



class RemoveBaseDocumentDefinitionElement(XsltElement):
    """
    Remove a document definition from a document definitions base defs.
    """

    content = None

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(default=None,
					       description='The path of the document'),
        'docdef' : AttributeInfo.UriReferenceAvt(required=1,
						 description='The document definition to use'),
        }

    childArgument = None

    def __init__(self, root, namespaceUri, localName, baseUri):
        XsltElement.__init__(self, root, namespaceUri, localName, baseUri)
        return

    def instantiate(self, context, processor):
        context.setProcessState(self)

        path = self._path.evaluate(context)
        dd = self._docdef.evaluate(context)

        base = FtssXsltBase.FetchBaseObject(processor, path)
	docdef = FtssXsltBase.FetchBaseObject(processor, dd)

	base.removeBaseDocumentDefinition(docdef);

        return (context,)



class SetCreationParamsElement(XsltElement):
    """
    Change the creation params of a document definition.
    """

    content = ContentInfo.Template

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(default=None,
					       description='The path for the new document'),
        }

    childArgument = ('src', 1, None, 'The new creation params in serialized format.')

    def __init__(self, root, namespaceUri, localName, baseUri):
        XsltElement.__init__(self, root, namespaceUri, localName, baseUri)
        self._output_parameters = OutputParameters.OutputParameters()
        return

    def instantiate(self, context, processor):
        context.setProcessState(self)

        path = self._path.evaluate(context)

        stream = cStringIO.StringIO()

        processor.addHandler(self._output_parameters, stream)
        for child in self.children:
            context = child.instantiate(context, processor)[0]
        processor.removeHandler()

        text = stream.getvalue()
        base = FtssXsltBase.FetchBaseObject(processor, path)

	cp = CreationParams.Deserialize(text)
	base.setCreationParams(cp);

        return (context,)




ExtFunctions = {
    (SCORE_NS, 'get-creation-params'): GetCreationParams,    
    (SCORE_NS, 'get-base-definitions'): GetBaseDefinitions,    
    (SCORE_NS, 'get-derived-definitions'): GetDerivedDefinitions,    
}

ExtElements = {
    (SCORE_NS, 'set-creation-params'): SetCreationParamsElement,
    (SCORE_NS, 'add-base-document-definition'): AddBaseDocumentDefinitionElement,
    (SCORE_NS, 'remove-base-document-definition'): RemoveBaseDocumentDefinitionElement,
}
