########################################################################
#
# File Name:            Server.py
#
"""
XSLT and XPath extensions supporting the 4SS Server API
WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ns import SCORE_NS
from Ft.Xml.XPath import Conversions

def GetAvailableModules(context):
    doc = context.node.rootNode
    from Ft.Server.Server import Modules

    return map(doc.createTextNode, Modules._ft_builtins.keys())

def GetAvailableHandlers(context,module):
    module = Conversions.StringValue(module)
    doc = context.node.rootNode
    from Ft.Server.Server import Modules
    mod = Modules._ft_builtins.get(module,None)
    if mod == None: return ""
    if not hasattr(mod,"handlers"): return ""
    return map(doc.createTextNode, getattr(mod,"handlers").keys())

    

ExtFunctions = {
    (SCORE_NS, 'get-available-modules'): GetAvailableModules,    
    (SCORE_NS, 'get-available-handlers'): GetAvailableHandlers,    
}

ExtElements = {
#    (NS, 'repo-text-reindex'): TextReindexRepositoryElement,
}
