<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:transform [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY bm "http://chimezie.ogbuji.net/bookmark-manager.rdfs#">
  <!ENTITY fschema "http://schemas.4suite.org/4ss#">
]>

<xsl:transform
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
  xmlns:fres="&fres;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:xbel="http://rdfinference.org/schemata/xbel/"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  xmlns:vsort="http://rdfinference.org/versa/0/2/sort/"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="fres fcore frdf fhttp exslt exslt-set exslt-math exslt-functions exslt-date-time xbel rdf f vsort"
>

  <!-- this query string param will have been set to 1 if the previous login attempt failed -->
  <xsl:param name="invalid" select="0"/>
  <!-- this query string param will have been set to 1 if the session expired -->
  <xsl:param name="post-login" select="private/portals.html"/>
  <xsl:param name="expired" select="0"/>
  <xsl:param name="fres:uri-path"/>
  <xsl:param name="focus"/>
  <xsl:param name="search"/>

  <xsl:output method="html"/>

  <xsl:template match="/">
    <html>
      <head>
        <title>BookerT - The Smart Bookmark Manager</title>
        <link rel="stylesheet" type="text/css" href="main.css"/>
        <script language="JavaScript1.2" type="text/javascript">
          <xsl:comment>
function search()
{
  window.location = "/BookerT/?xslt=index.xslt" + document.searchform.what.value;
};

function search()
{
  var win = window.open("/BookerT/edit.html?");
};
          </xsl:comment>
        </script>
      </head>
      <body>
        <xsl:call-template name="heading"/>
        <hr/>
        <div>
          <table width="100%">
            <tr>
              <td width="70%">
                <xsl:call-template name="bookmarks"/>
              </td>
              <td width="30%">
                <xsl:call-template name="controls"/>
              </td>
            </tr>
          </table>
        </div>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="heading">
    <table width="100%">
      <tr>
        <td><h1>BookerT - The Smart Bookmark Manager</h1></td>
        <td valign="bottom"><form name="searchform" method="get" action="javascript:search()"><small>search</small><input type="text" name="what" size="10" class="textBox" tabindex="3" disabled="disabled"/></form></td>
      </tr>
    </table>
    <table width="100%">
      <tr>
        <td>
          <xsl:text>[ </xsl:text>
          <xsl:choose>
            <xsl:when test="fcore:has-session()">
            <i>
              <xsl:text>You are logged in as </xsl:text>
              <b>
                <xsl:value-of select="fcore:get-current-username()"/>
              </b>
            </i>
            </xsl:when>
            <xsl:when test="$expired">
              <i>You were logged out due to inactivity. You must log in again.</i>
            </xsl:when>
            <xsl:otherwise>
              <i>You are not logged in. Log in as valid 4Suite user or as 'guest' with any password.</i>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:text> ]</xsl:text>
        </td>
        <td>
          <xsl:if test="$invalid">
            <font color="red"><xsl:text>(Invalid login attempted) </xsl:text></font>
          </xsl:if>
          <form method="post" action="{$fres:uri-path}">
            <input type="hidden" name="post-login" value="{fres:uri-path}private/portals.html"/>
            <input type="hidden" name="invalid-login" value="{fres:uri-path}?xslt=index.xslt&amp;invalid=1"/>
            <input type="hidden" name="action-name" value="login"/>
            User:&nbsp; <input type="text" name="user-name" size="10" class="textBox" tabindex="1"/>
            Passwd:&nbsp; <input type="password" name="password" size="10" class="textBox" tabindex="2"/>
            <input type="submit" value="login" class="button" name="login" tabindex="3"/>
          </form>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="controls">
  </xsl:template>

  <xsl:template name="bookmarks">
    <frdf:versa-assign query="type(xbel:collection) - xbel:contains -> *" name="bookmarks"/>
    <xsl:variable name="entries" f:node-set="yes">
      <xsl:choose>
        <xsl:when test="$search">
          <frdf:versa-query query="
distribute(
    filter($bookmarks - xbel:item -> *,
           '. - properties() -> contains(&quot;{$search}&quot;)'),
    '. - xbel:link -> *',
    '. - dc:title -> *',
    '. - xbel:classifiedAs -> *')
          "/>
        </xsl:when>
        <!-- Select the bookmarks with focus -->
        <xsl:when test="$focus">
          <frdf:versa-query query="
distribute(
    filter($bookmarks - xbel:item -> *,
           '. - xbel:classifiedAs -> eq(&quot;{$focus}&quot;)'),
    '. - xbel:link -> *',
    '. - dc:title -> *',
    '. - xbel:classifiedAs -> *')
          "/>
        </xsl:when>
        <xsl:otherwise>
          <frdf:versa-query query="
distribute(
    filter($bookmarks - xbel:item -> *,
           '. - xbel:favor -> eq(&quot;1000&quot;)'),
    '. - xbel:link -> *',
    '. - dc:title -> *',
    '. - xbel:classifiedAs -> *')
          "/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:for-each select="$entries/List/List">
      <xsl:variable name="link" select="string(List[1])"/>
      <xsl:variable name="title" select="string(List[2])"/>
      <xsl:variable name="subjects" select="List[3]/String"/>
      <xsl:if test="fcore:has-session()">
        <a href="javascript:edit('{$link}')">
          <img src="/ftss/data/icons/image1.gif" alt=" edit " width="16" height="16"/>
        </a>
      </xsl:if>
      <div>
        <a href="{$link}"><xsl:value-of select="$title"/></a>
        <xsl:text>&#160; &#160;</xsl:text>
        <span class="pivot">
        <xsl:for-each select="$subjects">
          <xsl:text>[</xsl:text>
            <a href="/BookerT/?xslt=index.xslt&amp;topic={.}">
              <xsl:value-of select="."/>
            </a>
          <xsl:text>]</xsl:text>
        </xsl:for-each>
        </span>
      </div>
    </xsl:for-each>
  </xsl:template>

</xsl:transform>

