<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc rdf bbschema">
  <!-- don't exclude bb prefix -->

  <!--
File:  submit-cart.xslt

Description:

    This stylesheet uses form data submitted from the new purchase page
    in order to store shopping cart information in the user's session
    data.

    This stylesheet can be applied to any XML source document, as long
    as the necessary form data comes in through the top-level params.

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:param name="prod-id"/>
  <xsl:param name="qty"/>
  <xsl:param name="actionToDo"/>
  <xsl:param name='fres:uri-path'/>
  <xsl:param name='fres:absolute-path'/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="fcore:has-session()">
        <xsl:choose>
          <xsl:when test="$actionToDo = 'add'">
            <!-- Create or replace the cart session data with the new items added -->
            <fcore:session-data key='CART'>
              <bb:pending date="{exslt-date-time:date-time()}">
                <xsl:copy-of select='fcore:session-data("CART")/bb:pending/*'/>
                <bb:order prod-id='{$prod-id}' qty='{$qty}' cust-id='{$fres:absolute-path}'/>
              </bb:pending>
            </fcore:session-data>
            <fhttp:response-uri uri="{$fres:uri-path}?xslt=../new-purchase.xslt"/>
          </xsl:when>
          <xsl:when test="$actionToDo = 'reset'">
            <!-- The cart might have items for multiple customers, so reset should only remove the items for the current customer -->
            <xsl:variable name='cart' select='fcore:session-data("CART")'/>

            <xsl:if test='$cart'>
              <fcore:session-data key='CART'>
                <bb:pending date="{$cart/bb:pending/@date}">
                  <xsl:copy-of select='$cart/bb:pending/bb:order[@cust-id != $fres:absolute-path]'/>
                </bb:pending>
              </fcore:session-data>
            </xsl:if>
            <!-- redirect back to the new purchase page -->
            <fhttp:response-uri uri="{$fres:uri-path}?xslt=../new-purchase.xslt"/>
          </xsl:when>
          <xsl:otherwise>Il n'y a rien</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <fhttp:response-uri uri="/buyerbase/?xslt=home.xslt"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
