########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/__init__.py,v 1.12 2004/08/30 22:34:15 mbrown Exp $
"""
4Suite repository implementation initialization, global constants

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import os, sys

from Ft import __version__

FTSERVER_NAMESPACE = 'http://xmlns.4suite.org/reserved'
RESERVED_NAMESPACE = 'http://xmlns.4suite.org/reserved'

SCHEMA_NSS = 'http://schemas.4suite.org/4ss'
TEMP_FILE_SCHEMA='%s#temp.file' % SCHEMA_NSS
SYSTEM_ID_BASE = "urn:4suite.org:4ss:repository:"
SWISH_SCHEMA='%s#metaxml.swish' % SCHEMA_NSS

# URI scheme for 4Suite repo resources
# (might someday be changed to something like
#  'vnd.fourthought.ftss' if proposed standards are adopted).
FTSS_URI_SCHEME = 'ftss'


class FtServerBaseException(Exception):
    # By defining our own __str__, we don't need to use
    # the __init__ from Exception.
    MessageSource = None
    def __init__(self, errorCode, **args):
        self.args = args
        # FIXME - remove this at some point
        self.params = args
        self.code = errorCode
        self.message = self.MessageSource.g_errorMessages[self.code] % self.params
        return

    def __repr__(self):
        return '%s: %s' %(self.__class__.__name__, self.message)

    def __str__(self):
        return self.message


