########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/XPath/ParsedAbbreviatedRelativeLocationPath.py,v 1.3 2003/02/12 16:24:14 uogbuji Exp $
"""
A parsed token that represents a abbreviated relative location path.

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Xml.XPath import ParsedNodeTest
from Ft.Xml.XPath import ParsedPredicateList
from Ft.Xml.XPath import ParsedAxisSpecifier
from Ft.Xml.XPath import ParsedStep

from Ft.Lib import Set

class ParsedAbbreviatedRelativeLocationPath:
    def __init__(self, left, right):
        """
        left can be a step or a relative location path
        right is only a step
        """
        self._left = left
        self._right = right
        nt = ParsedNodeTest.ParsedNodeTest('node', '')
        ppl = ParsedPredicateList.ParsedPredicateList([])
        as = ParsedAxisSpecifier.ParsedAxisSpecifier('descendant-or-self')
        self._middle = ParsedStep.ParsedStep(as, nt, ppl)
        return

    def evaluate(self, context):
        nodeset = self._left.select(context)

        state = context.copy()

        size = len(nodeset)
        result = []
        for pos in range(size):
            context.node, context.position, context.size = \
                          nodeset[pos], pos + 1, size
            subRt = self._middle.select(context)
            result = Set.Union(result, subRt)

        nodeset = result
        size = len(nodeset)
        result = []
        for pos in range(size):
            context.node, context.position, context.size = \
                          nodeset[pos], pos + 1, size
            subRt = self._right.select(context)
            result = Set.Union(result, subRt)

        context.set(state)
        return result
    select = evaluate

    def pprint(self, indent=''):
        print indent + str(self)
        self._left.pprint(indent + '  ')
        self._middle.pprint(indent + '  ')
        self._right.pprint(indent + '  ')

    def __str__(self):
        return '<AbbreviatedRelativeLocationPath at %x: %s>' % (
            id(self),
            repr(self),
            )
    
    def __repr__(self):
        return repr(self._left) + '//' + repr(self._right)

