########################################################################
#
# File Name:            ApplyTemplatesElement.py
#
# Documentation:        http://docs.4suite.org/4XSLT/ApplyTemplatesElement.py.html
#
"""
Implementation of the XSLT Spec apply-templates stylesheet element.
WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import types
from Ft.Xml import EMPTY_NAMESPACE
from Ft.Xml.Xslt import XsltElement, XSL_NAMESPACE, XsltRuntimeException, Error
from Ft.Xml.Xslt import CategoryTypes, AttributeInfo, ContentInfo
from Ft.Xml.Xslt.XPathExtensions import SortedExpression

class ApplyTemplatesElement(XsltElement):

    category = CategoryTypes.INSTRUCTION
    content = ContentInfo.Rep(
        ContentInfo.Alt(ContentInfo.QName(XSL_NAMESPACE, 'xsl:sort'),
                        ContentInfo.QName(XSL_NAMESPACE, 'xsl:with-param'))
        )
    legalAttrs = {
        'select' : AttributeInfo.Expression(),
        'mode' : AttributeInfo.QName(),
        }

    doesSetup = 1

    def setup(self):
        sort_keys = []
        self._params = []
        for child in self.children:
            if child.expandedName == (XSL_NAMESPACE, 'sort'):
                sort_keys.append(child)
            elif child.expandedName == (XSL_NAMESPACE, 'with-param'):
                self._params.append((child, child._name, child._select))
                
        if sort_keys:
            self._select = SortedExpression(self._select, sort_keys)
        return

    # hooks for Fourthought extension element (mode as AVT)

    def _instantiate_mode(self, context):
        return self._mode

    def instantiate(self, context, processor):
        context.processorNss = self.namespaces
        context.currentInstruction = self

        with_params = {}
        for (param, name, expr) in self._params:
            context.processorNss = param.namespaces
            context.currentInstruction = param
            with_params[name] = expr.evaluate(context)

        if self._select:
            node_set = self._select.evaluate(context)
            # it must really be a node-set, and if XSLT 1.0, not a result tree fragment
            if type(node_set) is not types.ListType:
                raise XsltRuntimeException(Error.ILLEGAL_APPLYTEMPLATE_NODESET, self)
        else:
            node_set = context.node.childNodes

        # Iterate over the nodes
        state = context.copy()
        mode = context.mode
        context.mode = self._instantiate_mode(context)

        pos = 1
        size = len(node_set)
        for node in node_set:
            context.node, context.position, context.size = node, pos, size
            processor.applyTemplates(context, with_params)
            pos += 1

        context.mode = mode
        context.set(state)

        return (context,)
