########################################################################
#
# File Name:            PlainTextWriter.py
#
# Documentation:        http://docs.4suite.org/4XSLT/PlainTextWriter.py.html
#
"""
Implements a text output writer for XSLT processor output
WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
import codecs
from Ft.Xml.Xslt import NullWriter

class PlainTextWriter(NullWriter.NullWriter):
    def __init__(self, outputParams, stream):
        NullWriter.NullWriter.__init__(self, outputParams)
        self._outputParams.setDefault('mediaType', 'text/plain')
        # the default is actually system-dependent; we'll use UTF-8
        self._outputParams.setDefault('encoding', 'utf-8')
        self._stream = codecs.lookup(self._outputParams.encoding)[3](stream)
        return

    # the NullWriter already defines the rest of the handlers as no-ops

    def getStream(self):
        return self._stream.stream

    def text(self, text, escapeOutput=1, asis=0):
        self._stream.write(text)
        return
