########################################################################
#
# File Name:            TextElement.py
#
# Documentation:        http://docs.4suite.org/4XSLT/TextElement.py.html
#
"""
Implementation of the XSLT Spec text stylesheet element.
WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from xml.dom import Node
from Ft.Xml import EMPTY_NAMESPACE
from Ft.Xml.Xslt import XsltElement, XsltException, Error, XSL_NAMESPACE
from Ft.Xml.Xslt import CategoryTypes, ContentInfo, AttributeInfo

class TextElement(XsltElement):
    category = CategoryTypes.INSTRUCTION
    content = ContentInfo.Text
    legalAttrs = {
        'disable-output-escaping' : AttributeInfo.YesNo(default='no'),
        }

    def instantiate(self, context, processor):
        if self.children:
            value = self.children[0].data
            if self._disable_output_escaping:
                processor.writers[-1].text(value, escapeOutput=0, asis=1)
            else:
                processor.writers[-1].text(value, asis=1)

        return (context,)

