########################################################################
# $Source: /var/local/cvsroot/4Suite/Ft/Xml/Xvif.py,v $ $Revision: 1.4 $ $Date: 2003/12/07 22:54:00 $
"""
XVIF integration for 4Suite.  Includes basic RELAX NG support

Copyright 2002 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

#See http://www.advogato.org/proj/xvif/

#Basic RELAX NG support

from xml.sax import make_parser, parseString, parse
from xml.dom import Node
from Ft.Xml import InputSource
from Ft.Xml.Domlette import NonvalidatingReader
from Ft.Xml.ThirdParty.Xvif import rng


class RelaxNgValidator:
    """
    EXPERIMENTAL
    A class providing RELAX NG support
    """
    def __init__(self, isrc):
        parser = make_parser()
        self._schema = rng.RngParser()
        parser.setContentHandler(self._schema)
        parser.setFeature("http://xml.org/sax/features/namespaces", 1)
        parser.parse(isrc.stream)

    def isValid(self, isrc):
        reader = NonvalidatingReader
        doc = reader.parse(isrc)
        return self.isValidNode(doc.firstChild)

    def isValidNode(self, node):
        deriv = self.validateNode(node)
        isvalid = deriv.nullable()
        #isvalid = isinstance(deriv, rng.Empty)
        return isvalid

    def validate(self, isrc):
        reader = NonvalidatingReader
        doc = reader.parse(isrc)
        return self.validateNode(doc.firstChild)

    def validateNode(self, node):
        if node.nodeType == Node.DOCUMENT_NODE:
            node = node.firstChild
        #s = copy.deepcopy(schema.grammar)
        return self._schema.grammar.deriv(node)


class RngInvalid(Exception):
    def __init__(self, rngResult):
        # By defining __str__, args will be available.  Otherwise
        # the __init__ of Exception sets it to the passed in arguments.
        self.message = rngResult.msg
        Exception.__init__(self, self.message)


##class XvifProcessor:
##    """
##    EXPERIMENTAL
##    A class providing XVIF processing support
##    """
##    def __init__(self, isrc):
##        parser = make_parser()
##        self._schema = rng.RngParser()
##        parser.setContentHandler(self._schema)
##        parser.setFeature("http://xml.org/sax/features/namespaces", 1)
##        parser.parse(isrc.stream)

##    def process(self, isrc):
##        reader = NonvalidatingReader
##        doc = reader.parse(isrc)
##        return self.execute(doc)

##    def execute(self, doc):
##        reader = NonvalidatingReader
##        doc = reader.parse(isrc)
##        #s = copy.deepcopy(schema.grammar)
##        deriv = self._schema.grammar.deriv(doc.firstChild)
##        #isvalid = deriv.isnullable()
##        isvalid = isinstance(deriv, rng.Empty)
##        return isvalid


