#ifndef __DOM__CHARDATA__
#define __DOM__CHARDATA__

#ifdef __cplusplus
extern "C" {
#endif


#include "Python.h"
#include "node.h"

  typedef struct {
    PyNode_HEAD
    PyObject *nodeValue;
  } PyCharacterDataObject;

#define PyCharacterData_Check(op) (PyText_Check(op) || PyComment_Check(op))


  /*Character Data Methods */
  extern PyObject *CharacterData_SubstringData(PyObject *node, int offset, int count);
  extern int CharacterData_AppendData(PyObject *node, PyObject *arg);
  extern int CharacterData_InsertData(PyObject *node, int offset, PyObject *arg);
  extern int CharacterData_DeleteData(PyObject *node, int offset, int count);
  extern int CharacterData_ReplaceData(PyObject *node, int offset, int count, PyObject *arg);


  extern int characterdata_setattr(PyCharacterDataObject *self, char *name, PyObject *v);
  
  extern PyObject *PyCharacterData_substringData(PyObject *, PyObject *);
  extern PyObject *PyCharacterData_appendData(PyObject *, PyObject *);
  extern PyObject *PyCharacterData_insertData(PyObject *, PyObject *);
  extern PyObject *PyCharacterData_deleteData(PyObject *, PyObject *);
  extern PyObject *PyCharacterData_replaceData(PyObject *, PyObject *);

#define CHARACTERDATA_METHODS \
    {"substringData", PyCharacterData_substringData, METH_VARARGS, "Return a Substring of the data"}, \
    {"appendData", PyCharacterData_appendData, METH_VARARGS, "append a string to the data"}, \
    {"insertData", PyCharacterData_insertData, METH_VARARGS, "Insert Data into this node"}, \
    {"deleteData", PyCharacterData_deleteData, METH_VARARGS, "delete a substring from the data"}, \
    {"replaceData", PyCharacterData_replaceData, METH_VARARGS, "Replace the characters starting at the offset with the specified string"}





#ifdef __cplusplus
}
#endif


#endif
