#ifndef _EXPAT_MODULE__
#define _EXPAT_MODULE__

#include "Python.h"
#include "expat.h"
#include "state_machine.h"
#include "ds_primitives.h"
#include "domlette.h"

/* Should not be a valid  XML character to ensure that splitting is correct. 
   Using a form-feed (ASCII character 12).
*/
#define EXPAT_NSSEP '\f'

#ifdef __cplusplus
extern "C" {
#endif

typedef struct NsMapping_ {
  PyObject *uri;
  PyObject *prefix;
} NsMapping;

typedef struct ParserState_ {
  State core;
  Stack *preserve_state;

  char in_dtd;

  PyDocumentObject *ownerDoc;

  Stack *node_stack;
  List *namespaces;
  PyObject *new_nss;
  PyObject *curr_text;

  unsigned long *docIx;
  Stack * xml_base_stack;

  PyObject *expat_charbuf;
  PyObject *expat_name;
  PyObject *expat_atts;
  PyObject *expat_prefix;
  PyObject *expat_uri;
  PyObject *expat_data;
  PyObject *expat_target;

  PyObject *input_source;

  List *visited_hrefs;
  int xinclude_content_depth;

  /* This stack allows element handlers to register events that are raised
     For the corresponding end element handler
     It is generally used to bind a start element handler to the matching
     end element handler using the state machine
  */
  Stack * elem_depth_event_stack;
  int * curr_elem_depth_event;
} ParserState;


  int initParser(XML_Parser *parser, ParserState *state);
  int doParse(XML_Parser parser, ParserState *state, PyObject *inputSource);

  PyObject *beginParse(PyObject *inputSource, int validate, int parseAsEntity);

  size_t readFromObject(PyObject *object, char *buf, int max);

#ifdef __cplusplus
}
#endif

#endif
