#ifndef __STATE_MACHINE__
#define __STATE_MACHINE__

#include "expat.h"
#include "ds_primitives.h"
#include "ds_tools.h"

#ifdef __cplusplus
extern "C" {
#endif

/* States */

#define ERROR_STATE 0
#define START_STATE 1

#define MAX_STATE 65536

/* Events */

#define ERROR_EVENT 0


typedef struct StateTableEntry_ {
  /* the transitions consists of alternating event and next state in pairs
     until 0 indicates the end */
  short *transitions;
  void (*handler)(void *userState, void *params);
  void *params;
  void (*destruct)(void *params);
} StateTableEntry;


typedef struct State_ {
  short current;
  /* make sure you use calloc to init this to 0 */
  StateTableEntry *table[MAX_STATE];
} State;


  int StateTable_Initialize(void *userState);
  void StateTable_Finalize(void *userState);

  int StateTable_AddStateWithHandlerParams(void *userState, short id, 
                                           void (*handler)(void *, void *), 
                                           void *params, 
                                           void (*destruct)(void *));
#define StateTable_AddState(state, id) \
StateTable_AddStateWithHandlerParams((state), (id), NULL, NULL, NULL)

#define StateTable_AddStateWithHandler(state, id, handler) \
StateTable_AddStateWithHandlerParams((state), (id), (handler), NULL, NULL)

  int StateTable_AddTransition(void *userState, short from, short event,
                               short next);

  void StateTable_Transit(void *userState, short event);
  void StateTable_SetState(void *userState, short new);

  void _StateTable_SignalError(void *userState, char *filename, int lineno);

#define StateTable_SignalError(state) \
_StateTable_SignalError((state), __FILE__, __LINE__)

#ifdef __cplusplus
}
#endif

#endif

