########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/__init__.py,v 1.30 2004/05/17 14:06:39 mbrown Exp $
"""
4Suite: an open-source platform for XML and RDF processing.

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import types
STRING_TYPES = [types.StringType, types.UnicodeType]
del types

# Determine natural platform charset
DEFAULT_ENCODING = 'US-ASCII'
try:
    import locale
except ImportError:
    pass
else:
    charset = locale.getlocale()[1]
    if charset is None:
        #Get around a Python bug on some platforms
        #see http://mail.python.org/pipermail/python-bugs-list/2002-July/012505.html
        try:
            # getdefaultlocale()[1] might be None
            charset = locale.getdefaultlocale()[1] or DEFAULT_ENCODING
        except:
            # Unable to determine platform encoding, only allow US-ASCII
            charset = DEFAULT_ENCODING

    DEFAULT_ENCODING = charset
    del locale
    del charset

#10,000 is the value from Python 1.5.2
MAX_PYTHON_RECURSION_DEPTH = 10000

class FtException(Exception):
    def __init__(self, errorCode, messages, args):
        # By defining __str__, args will be available.  Otherwise
        # the __init__ of Exception sets it to the passed in arguments.
        self.params = args
        self.errorCode = errorCode
        self.message = messages[errorCode] % args
        Exception.__init__(self, self.message, args)

    def __str__(self):
        return self.message

# Load the installation directories, only available from installed 4Suite
# or during setup via dummy module.
try:
    from __config__ import *
except ImportError:
    import os
    from distutils.fancy_getopt import wrap_text

    msg = """
4Suite is having trouble importing the modules it needs.
This is usually because the current working directory, which happens
to be %r at the moment, contains modules with names that are the
same as modules that 4Suite is trying to import. For example, 4Suite
cannot be invoked from the source code directory that contains the
setup.py that was used to install 4Suite.

Try changing the current working directory to a suitable location
outside of the 4Suite source. If you continue to have trouble,
please send a message to the 4Suite mailing list at
4suite@lists.fourthought.com, along with any information that might
explain why you got this message.
""" % os.getcwd()

    # Wrap the message to 78 characters preserving paragraphs
    lines = []
    for chunk in msg.split('\n\n'):
        lines.extend(wrap_text(chunk, 78))
        lines.append('')
    SystemExit('\n'.join(lines))
else:
    __version__ = VERSION

    # gettext has been part of the standard library since Python 2.0
    import gettext
    try:
        t = gettext.translation(NAME, LOCALEDIR)
    except IOError:
        # Bad or missing binary message catalog (.mo file)
        TranslateMessage = lambda s: s
    else:
        TranslateMessage = t.gettext
        del t
    del gettext
