import os, sys
from Ft.Rdf import Model
from Ft.Rdf.Serializers import Dom
from Ft.Xml import Domlette
# helper functions for statement comparision
from Rdf import RdfHelper

DATABASE_NAME = os.environ.get('RDF_TEST_DB', 'test')

SOURCE_URI = 'BASE'

source = """<rdf:RDF 
  xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
  xmlns:ns='http://my/ns#'>

  <ns:item rdf:ID='this'> <!-- typedNode -->
    <ns:prop>  <!-- propertyElt -->
      <ns:item>  <!-- typedNode -->
        <ns:prop resource='http://foo/'/>  <!-- propertyElt -->
      </ns:item> 
    </ns:prop> 
  </ns:item> 
</rdf:RDF>"""

deserialized = [
    ('%s#this' % SOURCE_URI,
     'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
     'http://my/ns#item',
     '',
     SOURCE_URI),
    ('ANONYMOUS0',
     'http://www.w3.org/1999/02/22-rdf-syntax-ns#type',
     'http://my/ns#item',
     '',
     SOURCE_URI),
    ('ANONYMOUS0',
     'http://my/ns#prop',
     'http://foo/',
     '',
     SOURCE_URI),
    ('%s#this' % SOURCE_URI,
     'http://my/ns#prop',
     'ANONYMOUS0',
     '',
     SOURCE_URI),
    ]

def Test(tester):
    tester.startTest('Initialize driver')
    driver = tester.test_data['driver']
    if driver.ExistsDb(DATABASE_NAME):
        driver.DestroyDb(DATABASE_NAME)
    driver.CreateDb(DATABASE_NAME)
    tester.testDone()
    
    tester.startTest('Property Elements')
    db = driver.GetDb('test')
    db.begin()
    model = Model.Model(db)
    serializer = Dom.Serializer()
    dom = Domlette.NonvalidatingReader.parseString(source,SOURCE_URI)
    serializer.deserialize(model, dom, SOURCE_URI)
    actual = RdfHelper.make_tuple(model.statements(), SOURCE_URI)
    tester.compare(deserialized, actual, func=RdfHelper.compare_tuple)
    db.rollback()
    tester.testDone()
    return
