import os, tempfile, sha
from Ft.Lib.TestSuite import TestMode
from Ft.Rdf import Statement, Model
from Ft.Rdf.Drivers import Memory
from Ft.Rdf.Serializers import Dom

g_configData = {}

SWISH_DIR = '/usr/local/src/swish++-4.8'

from Ft.Server.Common import ClAuthenticate
from Ft.Server.Server.Commands import Init
from Ft.Server.Server import SCore, Drivers
from Server import NullLogger

class _DbMode(TestMode.TestMode):
    databaseInited = {}

    def __init__(self):
        self.dbName = 'test_db'
        TestMode.TestMode.__init__(self,self.driverName,self.default)


    def _pre(self, tester):

        
        tester.test_data['driver'] = self.driverName
        if not tester.test_data.has_key('userName'):
            u,p = ('root','root')
            tester.test_data['userName'] = u
            tester.test_data['password'] = p

        if not self.databaseInited.has_key(self.driverName):
            self.createRepo(tester)
            _DbMode.databaseInited[self.driverName] = 1  


    def createRepo(self,tester):
    
        self._properties = {'SystemContainer':'/ftssSys',
                            'CoreId':'Core',
                            }
        self._properties['Driver']= self._getDriverProperties()

        tester.test_data['properties'] = self._properties


##        if os.path.exists(SWISH_DIR):
##            stmts.append(Statement.Statement('Core','http://xmlns.4Suite.org/4ss/properties#SwishExecDir',SWISH_DIR))
##            tester.test_data['has_swish'] = 1

##        #See if we need to add the CORBA stuff
##        try:
##            import omniORB
##        except Exception, error:
##            tester.warning("Unable to use omniORB, %s" % str(error))
##            tester.test_data['has_omniorb'] = 0


        tester.startTest("Init new Repo")

        mod = Drivers.LoadDriverModule(self._properties['Driver']['TYPE'])

        uname,passwd = tester.test_data['userName'],tester.test_data['password']
        Init.DoInit(self._properties,
                    uname,
                    passwd,
                    ['core'],
                    quiet = 1,
                    confirm = 0,
                    destroyRepo = mod.Exists(self._properties['Driver']) >= 0,
                    users = [(uname,passwd)],
                    )
        tester.testDone()


class _FlatFileMode(_DbMode):
    driverName = 'FlatFile'
    default = 1
##    def _init(self,tester):
##        try:
##            from Ft.Ods.StorageManager.Adapters import Dbm
##        except Exception, error:
##            tester.warning("Unable to use mode 'Dbm': %s" % (str(error)))
##            return 0
##        _OdsMode._init(self,tester)
##        return 1

    def _getDriverProperties(self):
        return {'TYPE': 'FlatFile', 'Root': 'testServer'} 

class _MySQLMode(_DbMode):
    driverName = 'MySQL'
    default = 0
    def _getDriverProperties(self):
        return {'TYPE': 'MySQL',
                'DbName': 'testserver',
                'Host':'localhost',
                'Port':-1,
                'User':None,
                'Passwd':None,
                }
    

class _PostgresMode(_DbMode):
    driverName = 'Postgres'
    default = 0

    def _getDriverProperties(self):
        return {'TYPE': 'Postgres',
                'DbName': 'testserver',
                'Host':None,
                'Port':-1,
                'User':None,
                'Passwd':None,
                }
