from Xml.Xslt import test_harness
from Ft.Lib import Uri
import os

base = os.getcwd()
if base[-1] != os.sep:
    base += os.sep
base = Uri.OsPathToUri(base)

SHEET_1 = """\
<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
  >

  <xsl:import href="Xml/Xslt/Core/test-apply-imports-1.xslt"/>

  <xsl:template match="example">
    <div style="border: solid red">
      <xsl:apply-imports/>
    </div>
  </xsl:template>

</xsl:stylesheet>
"""

SHEET_URI = base + 'sheet_string'

SOURCE_1 = "<example>This is an example</example>"

EXPECTED_1 = """\
<?xml version='1.0' encoding='UTF-8'?>
<div style="border: solid red"><pre>This is an example</pre></div>"""

SHEET_2 = """\
<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
  >

  <xsl:import href="Xml/Xslt/Core/test-apply-imports-2.xslt"/>

  <xsl:template match="doc">
    <body>
      <xsl:apply-imports/>
    </body>
  </xsl:template>

  <xsl:template match="*">
    <unknown-element><xsl:value-of select="name()"/></unknown-element>
  </xsl:template>

</xsl:stylesheet>
"""

SOURCE_2 = "<doc><example>This is an example<inconnu/></example></doc>"

EXPECTED_2 = """\
<?xml version="1.0" encoding="UTF-8"?>\n<body><div style="border: solid red"><unknown-element>example</unknown-element></div></body>"""


def Test(tester):
    source = test_harness.FileInfo(string=SOURCE_1)
    sheet = test_harness.FileInfo(string=SHEET_1, baseUri=SHEET_URI)
    test_harness.XsltTest(tester, source, [sheet], EXPECTED_1,
                          title='xsl:apply-imports 1')

    source = test_harness.FileInfo(string=SOURCE_2)
    sheet = test_harness.FileInfo(string=SHEET_2, baseUri=SHEET_URI)
    test_harness.XsltTest(tester, source, [sheet], EXPECTED_2,
                          title='xsl:apply-imports 2')
    return
