from Ft.Server import FTSERVER_NAMESPACE, RESERVED_NAMESPACE
from Ft.Server.Common import Schema, XmlLib, Util
from Ft.Server.Common import AclConstants, ResourceTypes
from Constants import UPDATE_ACL

class ACLManager:
    def getAclIdentifiers(self):
        self._verifyTx()
        return self._acl.getAclIdentifiers()

    def getAclIdent(self):
        self._verifyTx()
        return self._aclIdent
    def getAcl(self,path,access=None):
        self._verifyTx()
        self._acl.verifyFetch(path)
        return self._acl.getAcl(path,access)

    def setAcl(self,path,acl):
        self._verifyTx()
        self._acl.verifyChangePermissions(path)
        self._acl.clearCache()
        aclXml = self.aclToXml(acl)

        xu = UPDATE_ACL % (str(FTSERVER_NAMESPACE), aclXml)
        xu = XmlLib.MakeString(xu)
        self.xupdateMetaData(path,xu)

    def verifyAcl(self,path,access, verifyTraverse):
        self._verifyTx()
        self._acl.verifyAcl(path, access, verifyTraverse)
    def defaultAcl(self,user,owner):
        if user == owner:
            v = {owner:AclConstants.ALLOWED,
                 AclConstants.OWNER:AclConstants.ALLOWED}
        else:
            v = {user:AclConstants.ALLOWED,
                 owner:AclConstants.ALLOWED,
                 AclConstants.OWNER:AclConstants.ALLOWED,
                 }
        return {AclConstants.READ_ACCESS:v.copy(),
                AclConstants.WRITE_ACCESS:v.copy(),
                AclConstants.EXECUTE_ACCESS:v.copy(),
                AclConstants.DELETE_ACCESS:v.copy(),
                AclConstants.CHANGE_OWNER_ACCESS:v.copy(),
                AclConstants.CHANGE_PERMISSIONS_ACCESS:v.copy(),
                AclConstants.WRITE_USER_MODEL_ACCESS:v.copy(),
                #AclConstants.READ_METADATA_ACCESS:v.copy(),
                }

