########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Set/Docdef.py,v 1.7 2006/02/14 03:04:22 mbrown Exp $
"""
Implementation of '4ss set owner' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2006 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """These commands set or unset the docdef for a resource in a 4Suite \
repository. If necessary, you will be prompted first for credentials \
and access info to connect to the repository."""

import sys, fnmatch, posixpath

from Ft.Server.Client import FtServerClientException
from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import AclConstants, ResourceTypes, Schema


def Run(options, args):
    commit = False
    repo = CommandUtil.GetRepository(options, '4ss.set.docdef')
    if repo is None:
        print "failed to acquire repostory."
        sys.exit(-5)

    try:
        model      = repo.getModel()
        statements = model.complete(None, Schema.TYPE, None)
        done       = {}
        match_doc  = posixpath.normpath(args['document'])
        new_docdef = None
        if args.has_key('newdocdef'):
            new_docdef = repo.fetchResource(args['newdocdef'])

        for stmt in statements:
            doc_path = stmt.subject
            if not fnmatch.fnmatchcase(doc_path,match_doc):
                continue
            if doc_path in done.keys():
                continue
		
            #Keep track b|c one resource may appear multiple times in the model
            #(with different types, for example)
            done[doc_path] = True

            try:
                doc = repo.fetchResource(doc_path)
            except:
                #This resource is probably not a repository document.
                print "Couldn't resolve %s to a repository document."%doc_path
                continue;

            if new_docdef:
                print "Set docdef for %s to %s... "%(doc.getAbsolutePathAsUri(), new_docdef.getAbsolutePathAsUri()),
            else:
                print "Clearing docdef association for %s..."%doc.getAbsolutePathAsUri(),
            doc.setDocumentDefinition(new_docdef)
            print "Done."
	    	
        repo.txCommit()
    except:
        repo.txRollback()
        raise
    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('docdef',
                          'Set the docdef for a resource in a repository',
                          '<docdef-repo-uri> <document-repo-uri>',
                          __doc__,
                          function=Run,
                          arguments=[Arguments.RequiredArgument('document',
                                                                'uri or path of the resource',
                                                                str),
                                     Arguments.OptionalArgument('newdocdef',
                                                                'uri or path to the docdef to associate',
                                                                str),
                                     ],
                          options=Options.Options([
                                                   ]),
                          fileName=__file__,
                          )
    return cmd

