########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Update/RawFile.py,v 1.15 2004/10/09 03:21:41 mbrown Exp $
"""
Implementation of '4ss update rawfile' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command updates the content of an existing Raw File \
resource in a 4Suite repository. If necessary, you will be prompted \
first for credentials and access info to connect to the repository."""

import sys

from Ft.Lib import Uri
from Ft.Lib.CommandLine.CommandLineUtil import SourceArgToInputSource
from Ft.Server.Client.Commands import CommandUtil
from Ft.Xml.InputSource import DefaultFactory

def Run(options,args):
    sourceUri = args['sourceUri']
    try:
        isrc = SourceArgToInputSource(sourceUri, DefaultFactory)
    except Exception, e:
        sys.stderr.write(str(e)+'\n')
        sys.stderr.flush()
        return

    content = isrc.read()
    isrc.close()

    repo = CommandUtil.GetRepository(options,'4ss.update.rawfile')
    if repo is not None:
        commit = False
        try:
            doc = repo.fetchResource(args['path'])
            doc.setContent(content)
            if options.get('imt'):
                doc.setImt(options['imt'])
            commit = True
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass

    return


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('rawfile',
                          """Update the content of a Raw File in a repository""",
                          '/images/4suite.jpg /local/path/to/4Suite.jpg',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('path',
                                                                  "The repo path of the file",
                                                                  str),
                                       Arguments.RequiredArgument('sourceUri',
                                                                  "The URI to read the file's content from, or '-' for stdin",
                                                                  str),
                                       ],
                          options = Options.Options([Options.Option(None,
                                                                    'imt=',
                                                                    'The file\'s Internet Media Type. Default: no change.'),
                                                     ]),
                          fileName = __file__,
                          )
    return cmd


