/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __FIT_2D_SPHERE_FN_H
#define __FIT_2D_SPHERE_FN_H

// --- project includes ---
#include "nvector.h"
#include "nfunction.h"
#include "vector3.h"
#include "AGeometricObject.h"

class fit_2d_sphere_fn : public nfunction<double,2>
{
 private:
  const AGeometricObject *m_GO1,*m_GO2,*m_GO3;

 public:
  fit_2d_sphere_fn(const AGeometricObject*,const AGeometricObject*,const AGeometricObject*);
  virtual ~fit_2d_sphere_fn(){};

  virtual double operator()(const nvector<double,2>&) const;
};

#endif // __FIT_2D_SPHERE_FN_H
