/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef GENERICSHAPE_H
#define GENERICSHAPE_H

#include <iostream>
#include <boost/regex.hpp>
#include "vector3.h"
#include "Shape.h"
#include "string"

using std::string;
using boost::regex;
using boost::regex_match;

class GenericShape : public Shape {
  public:
    GenericShape(string, string);
    void insert(Vector3 pos, double radius, MNTable3D* ntable, int, int);
    int bias();
    void setBias(int);

  protected:
    vector<Vector3> origins;
    vector<double> radii;
    vector<vector<int> > bonds;
};


#endif /* GENERICSHAPE_H */
