
/*****************************************************************************
*
* Copyright (c) 2003-2016 by The University of Queensland
* http://www.uq.edu.au
*
* Primary Business: Queensland, Australia
* Licensed under the Apache License, version 2.0
* http://www.apache.org/licenses/LICENSE-2.0
*
* Development until 2012 by Earth Systems Science Computational Center (ESSCC)
* Development 2012-2013 by School of Earth Sciences
* Development from 2014 by Centre for Geoscience Computing (GeoComp)
*
*****************************************************************************/


/****************************************************************************

  Assemblage routines: copies node coordinates into an expanded Data object.

*****************************************************************************/

#define ESNEEDPYTHON
#include "esysUtils/first.h"


#include "Util.h"
#include "Assemble.h"

#include <sstream>

namespace finley {

void Assemble_NodeCoordinates(const NodeFile* nodes, escript::Data& x)
{
    resetError();
    if (!nodes) return;

    const escript::DataTypes::ShapeType expectedShape(1, nodes->numDim);

    if (!x.numSamplesEqual(1, nodes->numNodes)) {
        setError(TYPE_ERROR, "Assemble_NodeCoordinates: illegal number of samples of Data object");
    } else if (x.getFunctionSpace().getTypeCode() != FINLEY_NODES) {
        setError(TYPE_ERROR, "Assemble_NodeCoordinates: Data object is not defined on nodes.");
    } else if (!x.actsExpanded()) {
        setError(TYPE_ERROR, "Assemble_NodeCoordinates: expanded Data object expected");
    } else if (x.getDataPointShape() != expectedShape) {
        std::stringstream ss;
        ss << "Assemble_NodeCoordinates: Data object of shape ("
            << nodes->numDim << ",) expected.";
        std::string errorMsg = ss.str();
        setError(TYPE_ERROR, errorMsg.c_str());
    } else {
        const size_t dim_size = nodes->numDim*sizeof(double);
        x.requireWrite();
#pragma omp parallel for
        for (int n=0; n<nodes->numNodes; n++)
            memcpy(x.getSampleDataRW(n),
                    &(nodes->Coordinates[INDEX2(0,n,nodes->numDim)]), dim_size);
    }
}

} // namespace finley

