#!/usr/bin/python

import sys, os.path
sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))

import unittest
from lpltk.LaunchpadService import LaunchpadService
from lpltk.attachments import *
from lpltk.person import *

class TestTags(unittest.TestCase):

    # setUp
    #
    def setUp(self):
        self.configuration = {}
        self.configuration['launchpad_services_root'] = 'edge'
        self.configuration['read_only']               = True

    # tearDown
    #
    def tearDown(self):
        pass

    # test__init__
    #
    def test__init__(self):
        # Attachments object creation
        #
        print
        try:
            ls  = LaunchpadService(self.configuration)
            bug = ls.get_bug(107232)
            attachments = bug.attachments

            print "Class:   %s" %(type(attachments))
            print "Atts:    %d" %(len(attachments))
            for attachment in attachments:
                print "  Type:  %s" %(type(attachment))
                print "  Title: %s" %(attachment.title)
                print "  Kind:  %s" %(attachment.kind)
                print

        finally:
            bug = None
            ls  = None

    def test_attachment_owner(self):
        print
        try:
            ls  = LaunchpadService(self.configuration)
            bug = ls.get_bug(107232)
            attachments = bug.attachments

            for attachment in attachments:
                assert(attachment.owner)
                print "  Owner: %s" %(attachment.owner.lpperson)
                print "  First: %s" %(attachment.owner.first_name)
                print "  Msg:   %s chars" %(len(attachment.message.content))
                print "  Age:   %s days" %(attachment.age)
                print

        finally:
            bug = None
            ls  = None

    def test_attachment_contents(self):
        print
        try:
            ls  = LaunchpadService(self.configuration)
            bug = ls.get_bug(107232)
            attachments = bug.attachments

            for attachment in attachments:
                print "  filename:     %s" %(attachment.filename)
                print "  content-type: %s" %(attachment.content_type)
                print "  content:      %s chars" %(len(attachment.content))
                print "  patch?        %s" %(attachment.is_patch())
                print "  archive?      %s" %(attachment.is_archive())
                print

        finally:
            bug = None
            ls  = None

    def test_containment(self):
        print
        try:
            ls  = LaunchpadService(self.configuration)
            bug = ls.get_bug(107232)
            attachments = bug.attachments

            # Test containment
            attachment = attachments[0]
            if not attachment in attachments:
                raise AssertionError
            else:
                print "Located attachment in collection"

        finally:
            bug = None
            ls  = None

    def test_requirements(self):
        print
        try:
            ls  = LaunchpadService(self.configuration)
            bug = ls.get_bug(107232)
            attachments = bug.attachments

            missing = attachments.check_required_files(['*.tar.gz', 'alsa.*', 'faslkjasdfnfds*asdfdsaa'])
            if len(missing)>1:
                print "Unexpectedly missing files %s" %(missing)
                raise AssertionError

            print "Required files present and accounted for, except: %s" %(missing)

        finally:
            bug = None
            ls  = None

    def test_owner_filtered_attachments(self):
        print
        try:
            ls  = LaunchpadService(self.configuration)
            bug = ls.get_bug(107232)
            lark = Person(bug, ls.launchpad.people['florent-g'])
            attachments = bug.attachments

            # Test len()
            print "  %d attachments before filtering" %(len(attachments))
            attachments.add_filter(filter_owned_by_person, [lark])
            print "  %d attachments after filtering" %(len(attachments))
            print

            # Test iteration
            for attachment in attachments:
                print "  Type:  %s" %(type(attachment))
                print "  Title: %s" %(attachment.title)
                print "  Owner:  %s" %(attachment.owner.full_name)
                print

        finally:
            bug = None
            ls  = None

    def test_filename_filtered_attachments(self):
        print
        try:
            ls  = LaunchpadService(self.configuration)
            bug = ls.get_bug(570228)
            attachments = bug.attachments

            glob_patterns = ["*Xorg*Log*", "*Dmesg.txt"]

            print "  %d attachments before filtering" %(len(attachments))
            attachments.add_filter(filter_filename_matches_globs, glob_patterns)
            print "  %d attachments after filtering on filenames" %(len(attachments))

            age = 0
            for attachment in attachments:
                age = attachment.age

            attachments.add_filter(filter_age_between, [age-1, age+1])
            print "  %d attachments after filtering on age" %(len(attachments))
            print

        finally:
            bug = None
            ls  = None


if __name__ == '__main__':
    unittest.main()

# vi:set ts=4 sw=4 expandtab:
