# -*- coding: utf-8 -*-

# Copyright (C) 2010-2011 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
#
# Python X2go is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Python X2go is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""\
L{X2goClientPrintingGCONF} class is one of Python X2go's public API classes. 

Retrieve an instance of this class from your L{X2goClient} instance.
Use this class in your Python X2go based applications to access the »printing« 
configuration of your X2go client application.

"""
__NAME__ = 'x2goprint-pylib'

# modules
import types
import ConfigParser

# Python X2go modules
import x2go.log as log
import x2go.printactions as printactions
# we hide the default values from epydoc (that's why we transform them to _UNDERSCORE variables)
from x2go.defaults import X2GO_CLIENTPRINTING_DEFAULTS as _X2GO_CLIENTPRINTING_DEFAULTS
from x2go.defaults import X2GO_PRINTING_CONFIGFILES as _X2GO_PRINTING_CONFIGFILES
import x2go.inifiles as inifiles

from x2go.x2go_exceptions import *

class X2goClientPrintingGCONF(inifiles.X2goIniFile):
    """\
    L{X2goClientPrinting} provides access to the X2go ini-like file
    »printing« as stored in C{~/.x2goclient/printing} resp. globally
    C{/etc/x2goclient/printing}.

    An instance of L{X2goClientPrinting} is created on each incoming
    print job. This facilitates that on every print job the print action
    for this job is derived from the »printing« configuration file.

    Thus, changes on the file are active for the next incoming print job.

    """
    config_files = []
    _print_action = None
    defaultValues = _X2GO_CLIENTPRINTING_DEFAULTS

    def __init__(self, config_files=_X2GO_PRINTING_CONFIGFILES, defaults=None, logger=None, loglevel=log.loglevel_DEFAULT):
        """\
        @param config_files: a list of configuration files names (e.g. a global filename and a user's home 
            directory filename)
        @type config_files: C{list}
        @param defaults: a cascaded Python dicitionary structure with ini file defaults (to override 
            Python X2go's hard coded defaults in L{defaults}
        @type defaults: C{dict}
        @param logger: you can pass an L{X2goLogger} object to the
            L{X2goPrintAction} constructor
        @type logger: C{instance}
        @param loglevel: if no L{X2goLogger} object has been supplied a new one will be
            constructed with the given loglevel
        @type loglevel: C{int}

        """
        raise X2goNotImplementedYetException('GCONF backend support is not implemented yet')


