#
# Copyright (c) 2002, 2003 Art Haas
#
# This file is part of PythonCAD.
# 
# PythonCAD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# PythonCAD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with PythonCAD; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# code for setting the preferences of an image
#

import gtk

import Generic.text
import Generic.units

def set_dimension_prefs(gtkimage, prefdict):
    assert prefdict.has_key('OFFSET_ENTRY'), "Missing OFFSET_ENTRY"
    _text = prefdict['OFFSET_ENTRY'].get_chars(0, -1)
    if len(_text) and _text != '+':
        _offset = float(_text)
        gtkimage.setOption('DIM_OFFSET', _offset)
    assert prefdict.has_key('EXTENSION_ENTRY'), "Missing EXTENSION_ENTRY"
    _text = prefdict['EXTENSION_ENTRY'].get_chars(0, -1)
    if len(_text) and _text != '+':
        _extlen = float(_text)
        gtkimage.setOption('DIM_EXTENSION', _extlen)
    assert prefdict.has_key('DIM_POS_MENU'), "Missing DIM_POS_MENU"
    pos = prefdict['DIM_POS_MENU'].get_history()
    gtkimage.setOption('DIM_POSITION', pos)
    assert prefdict.has_key('DIM_EPT_MENU'), "Missing DIM_EPT_MENU"
    ept = prefdict['DIM_EPT_MENU'].get_history()
    gtkimage.setOption('DIM_ENDPOINT', ept)    
    assert prefdict.has_key('EPT_SIZE_ENTRY'), "Missing EPT_SIZE_ENTRY"
    _text = prefdict['EPT_SIZE_ENTRY'].get_chars(0, -1)
    if len(_text) and _text != '+':
        _size = float(_text)
        gtkimage.setOption('DIM_ENDPOINT_SIZE', _size)
    assert prefdict.has_key('DUAL_MODE_CB'), "Missing DUAL_MODE_CB"
    val = prefdict['DUAL_MODE_CB'].get_active()
    if val:
        state = True
    else:
        state = False
    gtkimage.setOption('DIM_DUAL_MODE', state)
    
    assert prefdict.has_key('PRIMARY_UNITS_MENU'), "Missing PRIMARY_UNITS_MENU"
    unit = prefdict['PRIMARY_UNITS_MENU'].get_history()
    gtkimage.setOption('DIM_PRIMARY_UNITS', unit)
    assert prefdict.has_key('PRIMARY_PREFIX_EB'), "Missing PRIMARY_PREFIX_EB"
    chars = prefdict['PRIMARY_PREFIX_EB'].get_chars(0,-1)
    if chars == "":
        pfx = u''
    else:
        try:
            pfx = unicode(chars)
        except:
            pfx = u'' # bailout?
    gtkimage.setOption('DIM_PRIMARY_PREFIX', pfx)
    assert prefdict.has_key('PRIMARY_SUFFIX_EB'), "Missing PRIMARY_SUFFIX_EB"
    chars = prefdict['PRIMARY_SUFFIX_EB'].get_chars(0,-1)
    if chars == "":
        sfx = u''
    else:
        try:
            sfx = unicode(chars)
        except:
            sfx = u'' # bailout?
    gtkimage.setOption('DIM_PRIMARY_SUFFIX', sfx)
    assert prefdict.has_key('PRIMARY_PREC_SB'), "Missing PRIMARY_PREC_SB"
    prec = prefdict['PRIMARY_PREC_SB'].get_value()
    gtkimage.setOption('DIM_PRIMARY_PRECISION', prec)
    assert prefdict.has_key('PRIMARY_LZ_CB'), 'Missing PRIMARY_LZ_CB'
    val = prefdict['PRIMARY_LZ_CB'].get_active()
    if val:
        state = True
    else:
        state = False
    gtkimage.setOption('DIM_PRIMARY_LEADING_ZERO', state)
    assert prefdict.has_key('PRIMARY_TD_CB'), 'Missing PRIMARY_TD_CB'
    val = prefdict['PRIMARY_TD_CB'].get_active()
    if val:
        state = True
    else:
        state = False
    gtkimage.setOption('DIM_PRIMARY_TRAILING_DECIMAL', state)

    assert prefdict.has_key('SECONDARY_UNITS_MENU'), "Missing SECONDARY_UNITS_MENU"
    unit = prefdict['SECONDARY_UNITS_MENU'].get_history()
    gtkimage.setOption('DIM_SECONDARY_UNITS', unit)
    assert prefdict.has_key('SECONDARY_PREFIX_EB'), "Missing SECONDARY_PREFIX_EB"
    chars = prefdict['SECONDARY_PREFIX_EB'].get_chars(0,-1)
    if chars == "":
        pfx = u''
    else:
        try:
            pfx = unicode(chars)
        except:
            pfx = u'' # bailout?
    gtkimage.setOption('DIM_SECONDARY_PREFIX', pfx)
    assert prefdict.has_key('SECONDARY_SUFFIX_EB'), "Missing SECONDARY_SUFFIX_EB"
    chars = prefdict['SECONDARY_SUFFIX_EB'].get_chars(0,-1)
    if chars == "":
        sfx = u''
    else:
        try:
            sfx = unicode(chars)
        except:
            sfx = u'' # bailout?
    gtkimage.setOption('DIM_SECONDARY_SUFFIX', sfx)
    assert prefdict.has_key('SECONDARY_PREC_SB'), "Missing SECONDARY_PREC_SB"
    prec = prefdict['SECONDARY_PREC_SB'].get_value()
    gtkimage.setOption('DIM_SECONDARY_PRECISION', prec)
    assert prefdict.has_key('SECONDARY_LZ_CB'), 'Missing SECONDARY_LZ_CB'
    val = prefdict['SECONDARY_LZ_CB'].get_active()
    if val:
        state = True
    else:
        state = False
    gtkimage.setOption('DIM_SECONDARY_LEADING_ZERO', state)
    assert prefdict.has_key('SECONDARY_TD_CB'), 'Missing SECONDARY_TD_CB'
    val = prefdict['SECONDARY_TD_CB'].get_active()
    if val:
        state = True
    else:
        state = False
    gtkimage.setOption('DIM_SECONDARY_TRAILING_DECIMAL', state)

    #
    # radial dimension prefix & suffix
    #
    
    assert prefdict.has_key('RADIAL_PRIMARY_PREFIX_EB'), "Missing RADIAL_PRIMARY_PREFIX_EB"
    chars = prefdict['RADIAL_PRIMARY_PREFIX_EB'].get_chars(0,-1)
    if chars == "":
        pfx = u''
    else:
        try:
            pfx = unicode(chars)
        except:
            pfx = u'' # bailout?
    gtkimage.setOption('RADIAL_DIM_PRIMARY_PREFIX', pfx)
    assert prefdict.has_key('RADIAL_SECONDARY_SUFFIX_EB'), "Missing RADIAL_SECONDARY_SUFFIX_EB"    
    chars = prefdict['RADIAL_PRIMARY_SUFFIX_EB'].get_chars(0,-1)
    if chars == "":
        sfx = u''
    else:
        try:
            sfx = unicode(chars)
        except:
            sfx = u'' # bailout?
    gtkimage.setOption('RADIAL_DIM_PRIMARY_SUFFIX', sfx)

    assert prefdict.has_key('RADIAL_SECONDARY_PREFIX_EB'), "Missing RADIAL_SECONDARY_PREFIX_EB"
    chars = prefdict['RADIAL_SECONDARY_PREFIX_EB'].get_chars(0,-1)
    if chars == "":
        pfx = u''
    else:
        try:
            pfx = unicode(chars)
        except:
            pfx = u'' # bailout?
    gtkimage.setOption('RADIAL_DIM_SECONDARY_PREFIX', pfx)
    assert prefdict.has_key('RADIAL_SECONDARY_SUFFIX_EB'), "Missing RADIAL_SECONDARY_SUFFIX_EB"    
    chars = prefdict['RADIAL_SECONDARY_SUFFIX_EB'].get_chars(0,-1)
    if chars == "":
        sfx = u''
    else:
        try:
            sfx = unicode(chars)
        except:
            sfx = u'' # bailout?
    gtkimage.setOption('RADIAL_DIM_SECONDARY_SUFFIX', sfx)

    #
    # angular dimension prefix & suffix
    #
    
    assert prefdict.has_key('ANGULAR_PRIMARY_PREFIX_EB'), "Missing ANGULAR_PRIMARY_PREFIX_EB"
    chars = prefdict['ANGULAR_PRIMARY_PREFIX_EB'].get_chars(0,-1)
    if chars == "":
        pfx = u''
    else:
        try:
            pfx = unicode(chars)
        except:
            pfx = u'' # bailout?
    gtkimage.setOption('ANGULAR_DIM_PRIMARY_PREFIX', pfx)
    assert prefdict.has_key('ANGULAR_SECONDARY_SUFFIX_EB'), "Missing ANGULAR_SECONDARY_SUFFIX_EB"    
    chars = prefdict['ANGULAR_PRIMARY_SUFFIX_EB'].get_chars(0,-1)
    if chars == "":
        sfx = u''
    else:
        try:
            sfx = unicode(chars)
        except:
            sfx = u'' # bailout?
    gtkimage.setOption('ANGULAR_DIM_PRIMARY_SUFFIX', sfx)

    assert prefdict.has_key('ANGULAR_SECONDARY_PREFIX_EB'), "Missing ANGULAR_SECONDARY_PREFIX_EB"
    chars = prefdict['ANGULAR_SECONDARY_PREFIX_EB'].get_chars(0,-1)
    if chars == "":
        pfx = u''
    else:
        try:
            pfx = unicode(chars)
        except:
            pfx = u'' # bailout?
    gtkimage.setOption('ANGULAR_DIM_SECONDARY_PREFIX', pfx)
    assert prefdict.has_key('ANGULAR_SECONDARY_SUFFIX_EB'), "Missing ANGULAR_SECONDARY_SUFFIX_EB"    
    chars = prefdict['ANGULAR_SECONDARY_SUFFIX_EB'].get_chars(0,-1)
    if chars == "":
        sfx = u''
    else:
        try:
            sfx = unicode(chars)
        except:
            sfx = u'' # bailout?
    gtkimage.setOption('ANGULAR_DIM_SECONDARY_SUFFIX', sfx)

    #
    # fonts
    #

    assert prefdict.has_key('PRIMARY_FONT_SEL'), "Missing PRIMARY_FONT_SEL"
    fn = prefdict['PRIMARY_FONT_SEL'].get_font_name()
    family, style, weight, stretch, size = Generic.text.parse_font(fn)
    gtkimage.setOption('DIM_PRIMARY_FONT_FAMILY', family)
    gtkimage.setOption('DIM_PRIMARY_FONT_SIZE', size)
    gtkimage.setOption('DIM_PRIMARY_FONT_STYLE', style)
    gtkimage.setOption('DIM_PRIMARY_FONT_WEIGHT', weight)

    assert prefdict.has_key('SECONDARY_FONT_SEL'), "Missing SECONDARY_FONT_SEL"
    fn = prefdict['SECONDARY_FONT_SEL'].get_font_name()
    family, style, weight, stretch, size = Generic.text.parse_font(fn)
    gtkimage.setOption('DIM_SECONDARY_FONT_FAMILY', family)
    gtkimage.setOption('DIM_SECONDARY_FONT_SIZE', size)
    gtkimage.setOption('DIM_SECONDARY_FONT_STYLE', style)
    gtkimage.setOption('DIM_SECONDARY_FONT_WEIGHT', weight)

#
# common routines for entry box validation
#
# eventually the preferences will be combined into a single
# dialog display so the duplication of code here and in gtkprefs.py
# will go away ...
#

def _entry_move_cursor(entry):
    entry.set_position(-1)
    return gtk.FALSE

def _entry_activate(entry): # this probably isn't a good choice ...
    entry.stop_emission("activate")

def _entry_focus_out(entry, event):
    _text = entry.get_chars(0, -1)
    if _text == '-' or _text == '+':
        entry.delete_text(0, -1)
    return gtk.FALSE

def _entry_insert_text(entry, new_text, new_text_length, position):
    if (new_text.isdigit() or
        new_text == '.' or
        new_text == '+'):
        _string = entry.get_chars(0, -1) + new_text
        _hid = entry.get_data('handlerid')
        entry.handler_block(_hid)
        _pos = entry.get_position()
        _move = True
        if _string == '+':
            _pos = entry.insert_text(new_text, _pos)
        else:
            try:
                _val = float(_string)
                _pos = entry.insert_text(new_text, _pos)
            except StandardError, e:
                _move = False
        entry.handler_unblock(_hid)
        gtk.idle_add(_entry_move_cursor, entry)
    entry.stop_emission("insert-text")

#

def add_secondary_font_page(gtkimage, pd, nb):
    vbox = gtk.VBox(gtk.FALSE, 2)
    frame = gtk.Frame("Secondary Dimension Font Properties")
    vbox.pack_start(frame, gtk.FALSE, gtk.FALSE)
    
    fw = gtk.FontSelection()
    fontlist = []
    fontlist.append(gtkimage.getOption('DIM_SECONDARY_FONT_FAMILY'))
    weight = gtkimage.getOption('DIM_SECONDARY_FONT_WEIGHT')
    if weight != Generic.text.NORMAL:
        if weight == 1:
            fontlist.append('Light')
        elif weight == 2:
            fontlist.append('Bold')
        elif weight == 3:
            fontlist.append('Heavy')
    style = gtkimage.getOption('DIM_SECONDARY_FONT_STYLE')
    if style != Generic.text.NORMAL:
        if style == 1:
            fontlist.append('Oblique')
        elif style == 2:
            fontlist.append('Italic')
    fontlist.append(str(gtkimage.getOption('DIM_SECONDARY_FONT_SIZE')))
    fw.set_font_name(' '.join(fontlist))
    pd['SECONDARY_FONT_SEL'] = fw
    frame.add(fw)
    vbox.show_all()

    lb = gtk.Label("Secondary Fonts")
    nb.append_page(vbox, lb)

def add_primary_font_page(gtkimage, pd, nb):
    vbox = gtk.VBox(gtk.FALSE, 2)
    frame = gtk.Frame("Primary Dimension Font Properties")
    vbox.pack_start(frame, gtk.FALSE, gtk.FALSE)
    
    fw = gtk.FontSelection()
    fontlist = []
    fontlist.append(gtkimage.getOption('DIM_PRIMARY_FONT_FAMILY'))
    weight = gtkimage.getOption('DIM_PRIMARY_FONT_WEIGHT')
    if weight != Generic.text.NORMAL:
        if weight == 1:
            fontlist.append('Light')
        elif weight == 2:
            fontlist.append('Bold')
        elif weight == 3:
            fontlist.append('Heavy')
    style = gtkimage.getOption('DIM_PRIMARY_FONT_STYLE')
    if style != Generic.text.NORMAL:
        if style == 1:
            fontlist.append('Oblique')
        elif style == 2:
            fontlist.append('Italic')
    fontlist.append(str(gtkimage.getOption('DIM_PRIMARY_FONT_SIZE')))
    fw.set_font_name(' '.join(fontlist))
    pd['PRIMARY_FONT_SEL'] = fw
    frame.add(fw)
    vbox.show_all()

    lb = gtk.Label("Primary Fonts")
    nb.append_page(vbox, lb)

def add_secondary_page(gtkimage, pd, nb):
    vbox = gtk.VBox(gtk.FALSE, 2)
    frame = gtk.Frame("Secondary Dimension")
    vbox.pack_start(frame, gtk.FALSE, gtk.FALSE)

    fvbox = gtk.VBox(gtk.FALSE, 2)
    frame.add(fvbox)
    
    hbox = gtk.HBox(gtk.FALSE, 2)
    ml = gtk.Label("Units:")
    hbox.pack_start(ml, gtk.FALSE, gtk.FALSE)
    menu = gtk.Menu()
    idx = 0
    unit_list = Generic.units.get_all_units()
    cur_unit = gtkimage.getOption('DIM_SECONDARY_UNITS')
    for i in xrange(len(unit_list)):
        if i == cur_unit:
            idx = i
        item = gtk.MenuItem(unit_list[i])
        menu.append(item)
    opt_menu = gtk.OptionMenu()
    opt_menu.set_menu(menu)
    opt_menu.set_history(idx)
    pd['SECONDARY_UNITS_MENU'] = opt_menu
    hbox.pack_start(opt_menu, gtk.FALSE, gtk.FALSE)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Prefix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)

    eb = gtk.Entry()
    prefix = gtkimage.getOption('DIM_SECONDARY_PREFIX')
    eb.set_text(prefix)
    pd['SECONDARY_PREFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)
    
    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Suffix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)
    eb = gtk.Entry()
    suffix = gtkimage.getOption('DIM_SECONDARY_SUFFIX')
    eb.set_text(suffix)
    pd['SECONDARY_SUFFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Display precision:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)
    prec = gtkimage.getOption('DIM_SECONDARY_PRECISION')
    adj = gtk.Adjustment(prec, 0, 15, 1, 1, 1)
    sb = gtk.SpinButton(adj)
    sb.set_digits(0)
    sb.set_numeric(gtk.TRUE)
    pd['SECONDARY_PREC_SB'] = sb
    hbox.pack_start(sb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    cb = gtk.CheckButton("Print leading 0")
    state = gtkimage.getOption('DIM_SECONDARY_LEADING_ZERO')
    cb.set_active(state)
    pd['SECONDARY_LZ_CB'] = cb
    fvbox.pack_start(cb, gtk.FALSE, gtk.FALSE)

    cb = gtk.CheckButton("Print trailing decimal point")
    state = gtkimage.getOption('DIM_SECONDARY_TRAILING_DECIMAL')
    cb.set_active(state)
    pd['SECONDARY_TD_CB'] = cb
    fvbox.pack_start(cb, gtk.FALSE, gtk.FALSE)

    vbox.show_all()
    
    tl = gtk.Label("Secondary")
    nb.append_page(vbox, tl)

def add_angular_page(gtkimage, pd, nb):
    vbox = gtk.VBox(gtk.FALSE, 2)
    frame = gtk.Frame("Angular Dimension Prefix & Suffix")
    vbox.pack_start(frame, gtk.FALSE, gtk.FALSE)

    fvbox = gtk.VBox(gtk.FALSE, 2)
    frame.add(fvbox)

    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Primary Prefix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)

    eb = gtk.Entry()
    prefix = gtkimage.getOption('ANGULAR_DIM_PRIMARY_PREFIX')
    eb.set_text(prefix)
    pd['ANGULAR_PRIMARY_PREFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)
    
    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Primary Suffix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)
    
    eb = gtk.Entry()
    suffix = gtkimage.getOption('ANGULAR_DIM_PRIMARY_SUFFIX')
    eb.set_text(suffix)
    pd['ANGULAR_PRIMARY_SUFFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Secondary Prefix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)

    eb = gtk.Entry()
    prefix = gtkimage.getOption('ANGULAR_DIM_SECONDARY_PREFIX')
    eb.set_text(prefix)
    pd['ANGULAR_SECONDARY_PREFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)
    
    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Secondary Suffix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)
    
    eb = gtk.Entry()
    suffix = gtkimage.getOption('ANGULAR_DIM_SECONDARY_SUFFIX')
    eb.set_text(suffix)
    pd['ANGULAR_SECONDARY_SUFFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    tl = gtk.Label("Angular")
    nb.append_page(vbox, tl)

def add_radial_page(gtkimage, pd, nb):
    vbox = gtk.VBox(gtk.FALSE, 2)
    frame = gtk.Frame("Radial Dimension Prefix & Suffix")
    vbox.pack_start(frame, gtk.FALSE, gtk.FALSE)

    fvbox = gtk.VBox(gtk.FALSE, 2)
    frame.add(fvbox)

    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Primary Prefix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)

    eb = gtk.Entry()
    prefix = gtkimage.getOption('RADIAL_DIM_PRIMARY_PREFIX')
    eb.set_text(prefix)
    pd['RADIAL_PRIMARY_PREFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)
    
    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Primary Suffix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)
    
    eb = gtk.Entry()
    suffix = gtkimage.getOption('RADIAL_DIM_PRIMARY_SUFFIX')
    eb.set_text(suffix)
    pd['RADIAL_PRIMARY_SUFFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Secondary Prefix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)

    eb = gtk.Entry()
    prefix = gtkimage.getOption('RADIAL_DIM_SECONDARY_PREFIX')
    eb.set_text(prefix)
    pd['RADIAL_SECONDARY_PREFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)
    
    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Secondary Suffix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)
    
    eb = gtk.Entry()
    suffix = gtkimage.getOption('RADIAL_DIM_SECONDARY_SUFFIX')
    eb.set_text(suffix)
    pd['RADIAL_SECONDARY_SUFFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    tl = gtk.Label("Radial")
    nb.append_page(vbox, tl)
    
def add_primary_page(gtkimage, pd, nb):
    vbox = gtk.VBox(gtk.FALSE, 2)
    frame = gtk.Frame("Primary Dimension")
    vbox.pack_start(frame, gtk.FALSE, gtk.FALSE)

    fvbox = gtk.VBox(gtk.FALSE, 2)
    frame.add(fvbox)
    
    hbox = gtk.HBox(gtk.FALSE, 2)
    ml = gtk.Label("Units:")
    hbox.pack_start(ml, gtk.FALSE, gtk.FALSE)
    menu = gtk.Menu()
    idx = 0
    unit_list = Generic.units.get_all_units()
    cur_unit = gtkimage.getOption('DIM_PRIMARY_UNITS')
    for i in xrange(len(unit_list)):
        if i == cur_unit:
            idx = i
        item = gtk.MenuItem(unit_list[i])
        menu.append(item)
    opt_menu = gtk.OptionMenu()
    opt_menu.set_menu(menu)
    opt_menu.set_history(idx)
    pd['PRIMARY_UNITS_MENU'] = opt_menu
    hbox.pack_start(opt_menu, gtk.FALSE, gtk.FALSE)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Prefix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)

    eb = gtk.Entry()
    prefix = gtkimage.getOption('DIM_PRIMARY_PREFIX')
    eb.set_text(prefix)
    pd['PRIMARY_PREFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)
    
    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Default Suffix:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)
    
    eb = gtk.Entry()
    suffix = gtkimage.getOption('DIM_PRIMARY_SUFFIX')
    eb.set_text(suffix)
    pd['PRIMARY_SUFFIX_EB'] = eb
    hbox.pack_start(eb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    hbox = gtk.HBox(gtk.FALSE, 2)
    lb = gtk.Label("Display precision:")
    hbox.pack_start(lb, gtk.FALSE, gtk.FALSE)
    prec = gtkimage.getOption('DIM_PRIMARY_PRECISION')
    adj = gtk.Adjustment(prec, 0, 15, 1, 1, 1)
    sb = gtk.SpinButton(adj)
    sb.set_digits(0)
    sb.set_numeric(gtk.TRUE)
    pd['PRIMARY_PREC_SB'] = sb
    hbox.pack_start(sb, gtk.TRUE, gtk.TRUE, 0)
    fvbox.pack_start(hbox, gtk.FALSE, gtk.FALSE)

    cb = gtk.CheckButton("Print leading 0")
    state = gtkimage.getOption('DIM_PRIMARY_LEADING_ZERO')
    cb.set_active(state)
    pd['PRIMARY_LZ_CB'] = cb
    fvbox.pack_start(cb, gtk.FALSE, gtk.FALSE)

    cb = gtk.CheckButton("Print trailing decimal point")
    state = gtkimage.getOption('DIM_PRIMARY_TRAILING_DECIMAL')
    cb.set_active(state)
    pd['PRIMARY_TD_CB'] = cb
    fvbox.pack_start(cb, gtk.FALSE, gtk.FALSE)

    vbox.show_all()
    
    tl = gtk.Label("Primary")
    nb.append_page(vbox, tl)

def add_common_page(gtkimage, pd, nb):
    _vbox = gtk.VBox(gtk.FALSE, 2)
    _frame = gtk.Frame("General Properties")
    _vbox.pack_start(_frame, gtk.FALSE, gtk.FALSE)

    _fvbox = gtk.VBox(gtk.FALSE, 2)
    _frame.add(_fvbox)

    _hbox = gtk.HBox(gtk.FALSE, 2)
    _label = gtk.Label("Offset length:")
    _hbox.pack_start(_label, gtk.FALSE, gtk.FALSE, 0)
    _offset = "%g" % gtkimage.getOption('DIM_OFFSET')
    _entry = gtk.Entry()
    _entry.set_text(_offset)
    _entry.connect("focus_out_event", _entry_focus_out)
    _entry.connect("activate", _entry_activate)
    _handlerid = _entry.connect("insert-text", _entry_insert_text)
    _entry.set_data('handlerid', _handlerid)
    pd['OFFSET_ENTRY'] = _entry
    _hbox.pack_start(_entry, gtk.TRUE, gtk.TRUE, 0)
    _fvbox.pack_start(_hbox, gtk.FALSE, gtk.FALSE, 0)

    _hbox = gtk.HBox(gtk.FALSE, 2)
    _label = gtk.Label("Extension length:")
    _hbox.pack_start(_label, gtk.FALSE, gtk.FALSE, 0)
    _extlen = "%g" % gtkimage.getOption('DIM_EXTENSION')
    _entry = gtk.Entry()
    _entry.set_text(_extlen)
    _entry.connect("focus_out_event", _entry_focus_out)
    _entry.connect("activate", _entry_activate)
    _handlerid = _entry.connect("insert-text", _entry_insert_text)
    _entry.set_data('handlerid', _handlerid)
    pd['EXTENSION_ENTRY'] = _entry
    _hbox.pack_start(_entry, gtk.TRUE, gtk.TRUE, 0)
    _fvbox.pack_start(_hbox, gtk.FALSE, gtk.FALSE, 0)

    _hbox = gtk.HBox(gtk.FALSE, 2)
    _label = gtk.Label("Dimension Position:")
    _hbox.pack_start(_label, gtk.FALSE, gtk.FALSE, 0)
    _menu = gtk.Menu()
    _idx = 0
    _opts = ['Split Line', 'Above Line', 'Below Line']
    _cur_pos = gtkimage.getOption('DIM_POSITION')
    for _i in xrange(len(_opts)):
        if _i == _cur_pos:
            _idx = _i
        _item = gtk.MenuItem(_opts[_i])
        _menu.append(_item)
    _opt_menu = gtk.OptionMenu()
    _opt_menu.set_menu(_menu)
    _opt_menu.set_history(_idx)
    pd['DIM_POS_MENU'] = _opt_menu
    _hbox.pack_start(_opt_menu, gtk.FALSE, gtk.FALSE, 0)
    _fvbox.pack_start(_hbox, gtk.FALSE, gtk.FALSE, 0)

    _hbox = gtk.HBox(gtk.FALSE, 2)
    _label = gtk.Label("Dimension Endpoint Style:")
    _hbox.pack_start(_label, gtk.FALSE, gtk.FALSE, 0)
    _menu = gtk.Menu()
    _idx = 0
    _opts = ['None', 'Arrow', 'Filled Arrow', 'Slash', 'Circle']
    _cur_ept = gtkimage.getOption('DIM_ENDPOINT')
    for _i in xrange(len(_opts)):
        if _i == _cur_ept:
            _idx = _i
        _item = gtk.MenuItem(_opts[_i])
        _menu.append(_item)
    _opt_menu = gtk.OptionMenu()
    _opt_menu.set_menu(_menu)
    _opt_menu.set_history(_idx)
    pd['DIM_EPT_MENU'] = _opt_menu
    _hbox.pack_start(_opt_menu, gtk.FALSE, gtk.FALSE, 0)
    _fvbox.pack_start(_hbox, gtk.FALSE, gtk.FALSE, 0)

    _hbox = gtk.HBox(gtk.FALSE, 2)
    _lb = gtk.Label("Endpoint Size:")
    _hbox.pack_start(_lb, gtk.FALSE, gtk.FALSE)
    _size = "%g" % gtkimage.getOption('DIM_ENDPOINT_SIZE')
    _entry = gtk.Entry()
    _entry.set_text(_size)
    _entry.connect("focus_out_event", _entry_focus_out)
    _entry.connect("activate", _entry_activate)
    _handlerid = _entry.connect("insert-text", _entry_insert_text)
    _entry.set_data('handlerid', _handlerid)
    pd['EPT_SIZE_ENTRY'] = _entry
    _hbox.pack_start(_entry, gtk.TRUE, gtk.TRUE, 0)
    _fvbox.pack_start(_hbox, gtk.FALSE, gtk.FALSE, 0)

    _cb = gtk.CheckButton("Display Secondary Dimension")
    _state = gtkimage.getOption('DIM_DUAL_MODE')
    _cb.set_active(_state)
    pd['DUAL_MODE_CB'] = _cb
    _fvbox.pack_start(_cb, gtk.FALSE, gtk.FALSE, 0)

    _label = gtk.Label("General")
    nb.append_page(_vbox, _label)

def check_dim_prefs(gtkimage):
    window = gtkimage.getWindow()
    dialog = gtk.Dialog("Dimension Preference", window,
                        gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                        (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                         gtk.STOCK_APPLY, gtk.RESPONSE_APPLY,
                         gtk.STOCK_OK, gtk.RESPONSE_OK))
    notebook = gtk.Notebook()
    pref_dict = {}
    dialog.vbox.pack_start(notebook, expand=gtk.TRUE)
    add_common_page(gtkimage, pref_dict, notebook)
    add_primary_page(gtkimage, pref_dict, notebook)
    add_secondary_page(gtkimage, pref_dict, notebook)
    add_radial_page(gtkimage, pref_dict, notebook)
    add_angular_page(gtkimage, pref_dict, notebook)
    add_primary_font_page(gtkimage, pref_dict, notebook)
    add_secondary_font_page(gtkimage, pref_dict, notebook)
    notebook.set_current_page(0)
    dialog.show_all()
    response = dialog.run()
    if response == gtk.RESPONSE_OK or response == gtk.RESPONSE_APPLY:
        print "got RESPONSE_OK or RESPONSE_APPLY"
        set_dimension_prefs(gtkimage, pref_dict)
    else:
        print "got RESPONSE_CANCEL"
    dialog.destroy()
