#
# Copyright (c) 2003, 2004 Art Haas
#
# This file is part of PythonCAD.
# 
# PythonCAD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# PythonCAD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with PythonCAD; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# GTK interface code for dealing with text entities
#

import pygtk
pygtk.require('2.0')
import gtk
import pango

import Generic.text

def draw_textblock(gtkimage, tblock, active):
    _da = gtkimage.getDA()
    _gc = _da.get_style().fg_gc[gtk.STATE_NORMAL]
    _text = tblock.getText()
    _family = tblock.getFamily()
    _style = tblock.getStyle()
    _weight = tblock.getWeight()
    _color = tblock.getColor()
    _size = tblock.getSize()
    _layout = make_pango_layout(gtkimage, _text, _family, _style,
                                _weight, _color, _size)
    _x, _y = tblock.getLocation()
    _px, _py = gtkimage.coordToPixTransform(_x, _y)
    _pixmap = gtkimage.getPixmap()
    _pixmap.draw_layout(_gc, _px, _py, _layout)
    
def make_pango_layout(gtkimage, text, family, style, weight, color, size):
    _layout = pango.Layout(gtkimage.getDA().get_pango_context())
    _layout.set_text(text)
    _attlist = pango.AttrList()
    _family = pango.AttrFamily(family)
    _family.start_index = 0
    _family.end_index = -1
    _attlist.insert(_family)
    _sty = pango.AttrStyle(style)
    _sty.start_index = 0
    _sty.end_index = -1
    _attlist.insert(_sty)
    _wt = pango.AttrWeight(weight)
    _wt.start_index = 0
    _wt.end_index = -1
    _attlist.insert(_wt)
    _r, _g, _b = color.getColors()
    _rs = int(65535.0 * (_r/255.0))
    _gs = int(65535.0 * (_g/255.0))
    _bs = int(65535.0 * (_b/255.0))
    _fg = pango.AttrForeground(_rs, _gs, _bs)
    _fg.start_index = 0
    _fg.end_index = -1
    _attlist.insert(_fg)
    _sz = pango.AttrSize(1024 * size) # need to scale
    _sz.start_index = 0
    _sz.end_index = -1
    _attlist.insert(_sz)
    _layout.set_attributes(_attlist)
    return _layout
    
def add_text(gtkimage, tool):
    _text = tool.getText()
    _x, _y = tool.getTextLocation()
    _textstyle = gtkimage.getOption('TEXT_STYLE')
    _tblock = Generic.text.TextBlock(_text, _textstyle)
    _tblock.setLocation(_x, _y)
    gtkimage.addObject(_tblock)
    
def text_button_press(gtkimage, widget, event, tool):
    _x, _y = gtkimage.getPoint()
    _tol = gtkimage.getTolerance()
    _pt, _flag = gtkimage.findPoint(_x, _y, _tol)
    if _pt is not None:
        _x, _y = _pt.getCoords()
    tool.setTextLocation(_x, _y)
    tool.create(gtkimage)
    gtkimage.redraw()
    # tool.clearCurrentPoint()
    
def text_motion_notify(gtkimage, widget, event, tool):
    _tw, _th = tool.getPixelSize()
    _gc = gtkimage.getGC()
    _x = int(event.x)
    _y = int(event.y)
    _cp = tool.getCurrentPoint()
    if _cp is not None:
        _xc, _yc = _cp
        widget.window.draw_rectangle(_gc, gtk.FALSE, _xc, _yc, _tw, _th)
    tool.setCurrentPoint(_x, _y)
    widget.window.draw_rectangle(_gc, gtk.FALSE, _x, _y, _tw, _th)

def text_add_init(gtkimage, tool):
    _text = tool.getText()
    _family = gtkimage.getOption('FONT_FAMILY')
    _weight = gtkimage.getOption('FONT_WEIGHT')
    _style = gtkimage.getOption('FONT_STYLE')
    _size = gtkimage.getOption('FONT_SIZE')
    _color = gtkimage.getOption('FONT_COLOR')
    _layout = make_pango_layout(gtkimage, _text, _family, _style, _weight,
                                _color, _size)
    tool.setLayout(_layout)
    _lw, _lh = _layout.get_pixel_size()
    tool.setPixelSize(_lw, _lh)
    tool.setHandler("motion_notify", text_motion_notify)
    tool.setHandler("button_press", text_button_press)
    gtkimage.setPrompt("Click where to place the text")
    _gc = gtkimage.getGC()
    _gc.set_line_attributes(1, gtk.gdk.LINE_SOLID,
                            gtk.gdk.CAP_BUTT, gtk.gdk.JOIN_MITER)
    _gc.set_function(gtk.gdk.INVERT)
    
    
def make_text_dialog(gtkimage, text=None):
    _window = gtkimage.getWindow()
    _dialog = gtk.Dialog("Enter text", _window,
                         gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                         (gtk.STOCK_OK, gtk.RESPONSE_OK,
                          gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
    _tb = gtk.TextBuffer()
    _tv = gtk.TextView(_tb)
    _sw = gtk.ScrolledWindow()
    _sw.set_size_request(400, 300)
    _sw.add_with_viewport(_tv)
    _dialog.vbox.pack_start(_sw, gtk.FALSE, gtk.FALSE, 0)
    _dialog.show_all()
    return _dialog, _tb

def get_new_text(gtkimage):
    _tool = gtkimage.getTool()
    _dialog, _tb = make_text_dialog(gtkimage)
    _response = _dialog.run()
    if _response == gtk.RESPONSE_OK:
        _start_iter, _end_iter = _tb.get_bounds()
        _text = _tb.get_text(_start_iter, _end_iter)
        if len(_text):
            _tool.setText(_text)
    _dialog.destroy()

