
"""
__version__ = "$Revision: 1.7 $"
__date__ = "$Date: 2002/03/04 00:57:09 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget

class StaticTextSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'StaticText'
        self.parent = 'Widget'
        self.parentName = self.parent
        self._attributes.update({
            'text' : { 'presence' : 'optional', 'default' : '' },
            'alignment' : { 'presence' : 'optional', 'default' : 'left', 'values' :[ 'left', 'right', 'center' ] }
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class StaticText(widget.Widget, wx.wxStaticText):
    """
    An uneditable block of text.
    """

    _spec = StaticTextSpec()

    def __init__( self, aParent, aResource ) :
        attributes = ['_alignment']
        self._createAttributes(attributes)
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxStaticText.__init__(
            self,
            aParent, 
            self.getId(), 
            aResource.text, 
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ),
            style = self.__getAlignment( aResource.alignment ) | wx.wxCLIP_SIBLINGS,
            name = aResource.name 
        )
        self._alignment = aResource.alignment

        if not hasattr(self.__class__, '_getText'):
            self.__class__._getText = self.__class__.GetLabel

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

    def _bindEvents(self):
        adapter = binding.wxPython_EventBinding(self)
        adapter.bindEvents()

    def __getAlignment( self, aString  ) :
        if aString == 'left' :
            return wx.wxALIGN_LEFT
        elif aString == 'center' :
            return wx.wxALIGN_CENTER | wx.wxST_NO_AUTORESIZE
        elif aString == 'right' :
            return wx.wxALIGN_RIGHT | wx.wxST_NO_AUTORESIZE
        else :
            raise 'invalid StaticText.alignment value: ', aString

    #def _bindEvents( self ) :
    #    pass

    #def _setHelpText( self, aString ) :
    #    pass

    """
    def _getText( self ) :
        return self.GetLabel()
    """

    def _setText( self, aString ) :
        self.SetLabel( aString )
        self.Refresh()

    def _getAlignment( self ) :
        return self._alignment

    def _setAlignment( self, aString ) :
        raise AttributeError, "alignment attribute is read-only"


registry.getRegistry().register( sys.modules[__name__].StaticText )
