# -*- coding: ISO-8859-1 -*-

# Copyright (C) 2002 Jrg Lehmann <joerg@luga.de>
#
# This file is part of PyTone (http://www.luga.de/pytone/)
#
# PyTone is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# PyTone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyX; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import time
import xmms

from services.player import genericplayer

# Note: the implementation xmms player is a bit hackish,
# so don't look too close. At many places, sleeps have
# been interted to get it working, so as I said...

class player(genericplayer):
    def __init__(self, id, session=0, autoplay=0, noqueue=0):
        self.session = session
        self.noqueue = noqueue

        # a mapping path -> song
        self.songs = {} 
        self.initxmms()
        
        genericplayer.__init__(self, id, autoplay)

    def initxmms(self):
        if not xmms.is_running(self.session):
            abs_prog_name = xmms._find_and_check_executable("xmms")
            if not abs_prog_name:
                raise xmms.ExecutableNotFound("can't find XMMS executable")
            os.system(abs_prog_name + " >/dev/null 2>/dev/null &")
            while not xmms.is_running(self.session):
                time.sleep(0.2)

        xmms.playlist_clear(self.session)
        xmms.main_win_toggle(0, self.session)
        xmms.pl_win_toggle(0, self.session)
        xmms.eq_win_toggle(0, self.session)

    # event handler

    def play(self):
        if xmms.is_playing(self.session):
            pos = xmms.get_playlist_pos(self.session)
            # title = xmms.get_playlist_title(pos, self.session)
            # ttime = xmms.get_playlist_time(pos, self.session)
            # ptime = xmms.get_output_time(self.session)
            # self.playbackinfo = (title, int(ptime/1000), int(ttime/1000))
            path = xmms.get_playlist_file(pos, self.session)
            song = self.songs[path]
            ptime = xmms.get_output_time(self.session)/1000
            self.playbackinfo.updatesong(song)
            self.playbackinfo.updatetime(ptime)

            # fill up xmms playlist if necessary
            if song.length-ptime<20 and xmms.get_playlist_length()<2: 
                self.requestnextsong()
            if pos>0:
                path = xmms.get_playlist_file(0, self.session)
                xmms.playlist_delete(0, self.session)
                del self.songs[path]
        else:
            self.playbackinfo.updatesong(None)

        time.sleep(0.1)

    def _playsong(self, song, manual):
        if self.noqueue:
            xmms.playlist_clear(self.session)
            self.songs = {}
            
        self.songs[song.path] = song
        xmms.playlist_add((song.path,), self.session)

        if not xmms.is_playing():
            xmms.play(self.session)
            # wait a little, so that xmms can start playing
            # and we don't request another song...
            time.sleep(0.5)

    def _playerstart(self):
        # before we start playing, we clear the playlist
        xmms.playlist_clear(self.session)
        self.songs = {}

    def _playerpause(self):
        # before we start playing, we clear the playlist
        xmms.pause(self.session)

    def _playerunpause(self):
        # before we start playing, we clear the playlist
        xmms.play(self.session)
    
    def _playerstop(self):
        xmms.playlist_clear(self.session)
        self.songs = {}

    def playerforward(self, event):
        if event.playerid==self.id:
            if xmms.is_playing(self.session):
                self.requestnextsong()
                # wait a little for the other threads, uuh...
                time.sleep(1)
                self.channel.process()
                time.sleep(0.1)
            xmms.playlist_next(self.session)

    def _playerquit(self):
        xmms.quit(self.session)

