# -*- coding: ISO-8859-1 -*-

# Copyright (C) 2002 Jrg Lehmann <joerg@luga.de>
#
# This file is part of PyTone (http://www.luga.de/pytone/)
#
# PyTone is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# PyTone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyTone; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

class request:
    def __str__(self):
        return self.__class__.__name__

    __repr__ = __str__

class dbrequest:
    def __init__(self, songdbid):
        self.songdbid = songdbid

    def __str__(self):
        return "%s->%s" % (self.__class__.__name__, self.songdbid)


class getdatabaseinfo(dbrequest):
    """ return tuple (type, location) of database """
    pass
        

class queryregistersong(dbrequest):
    def __init__(self, songdbid, path):
        self.songdbid = songdbid
        self.path = path
        
    def __str__(self):
        return "%s(%s)->%s" % (self.__class__.__name__, self.path, `self.songdbid`)


class getsong(dbrequest):
    def __init__(self, songdbid, path):
        self.songdbid = songdbid
        self.path = path
        
    def __str__(self):
        return "%s(%s)->%s" % (self.__class__.__name__, self.path, `self.songdbid`)


class getsongs(dbrequest):
    def __init__(self, songdbid, artist=None, album=None, indexname=None, indexid=None, random=None):
        self.songdbid = songdbid
        self.artist = artist
        self.album = album
        self.indexname = indexname
        self.indexid = indexid
        self.random = random
        
    def __str__(self):
        return ( "%s(artist=%s, album=%s, index=(%s->%s), random=%s)->%s" %
                 (self.__class__.__name__,
                  `self.artist`, `self.album`,
                  `self.indexname`, `self.indexid`,
                  `self.random`,
                  `self.songdbid`))

class getnumberofsongs(dbrequest):
    pass

class getnumberofdecades(dbrequest):
    pass

class getnumberofgenres(dbrequest):
    pass

class getnumberofratings(dbrequest):
    pass

class getnumberofalbums(dbrequest):
    pass

class getartists(dbrequest):
    def __init__(self, songdbid, indexname=None, indexid=None):
        self.songdbid = songdbid
        self.indexname = indexname
        self.indexid = indexid
        
    def __str__(self):
        return "%s(index=(%s->%s))->%s" % (self.__class__.__name__,
                                           `self.indexname`,
                                           `self.indexid`,
                                           `self.songdbid`)
    

class getalbums(dbrequest):
    def __init__(self, songdbid, artist=None, indexname=None, indexid=None):
        self.songdbid = songdbid
        self.artist = artist
        self.indexname = indexname
        self.indexid = indexid
        
    def __str__(self):
        return "%s(artist=%s, index(%s->%s))->%s" % (self.__class__.__name__,
                                                     `self.artist`,
                                                     `self.indexname`,
                                                     `self.indexid`,
                                                     `self.songdbid`)


class getalbum(dbrequest):
    def __init__(self, songdbid, album):
        self.songdbid = songdbid
        self.album = album
        
    def __str__(self):
        return "%s(album=%s)->%s" % (self.__class__.__name__, `self.album`, `self.songdbid`)


class getartist(dbrequest):
    def __init__(self, songdbid, artist):
        self.songdbid = songdbid
        self.artist = artist
        
    def __str__(self):
        return "%s(artist=%s)->%s" % (self.__class__.__name__, `self.artist`, `self.songdbid`)


class getgenres(dbrequest):
    pass


class getyears(dbrequest):
    pass


class getdecades(dbrequest):
    pass


class getratings(dbrequest):
    pass


class getlastplayedsongs(dbrequest):
    # returns a list of tuples (song, playingtime).
    # Due to the different structure of the result compared to the
    # other request, we do not support random song selection here.

    def __init__(self, songdbid):
        self.songdbid = songdbid

    def __str__(self):
        return "%s->%s" % (self.__class__.__name__, `self.songdbid`)


class gettopplayedsongs(dbrequest):
    def __init__(self, songdbid, random=None):
        self.songdbid = songdbid
        self.random = random

    def __str__(self):
        return "%s(random=%s)->%s" % (self.__class__.__name__, `self.random`, `self.songdbid`)

class getlastaddedsongs(dbrequest):
    def __init__(self, songdbid, random=None):
        self.songdbid = songdbid
        self.random = random

    def __str__(self):
        return "%s(random=%s)->%s" % (self.__class__.__name__, `self.random`, `self.songdbid`)

class getplaylist(dbrequest):
    def __init__(self, songdbid, path):
        self.songdbid = songdbid
        self.path = path
        
    def __str__(self):
        return "%s(%s)->%s" % (self.__class__.__name__, `self.path`, `self.songdbid`)


class getplaylists(dbrequest):
    pass

class getsongsinplaylist(dbrequest):
    """ return all songs store in playlist path """
    def __init__(self, songdbid, path, random=None):
        self.songdbid = songdbid
        self.path = path 
        self.random = random

    def __str__(self):
        return "%s(path=%s,random=%s)->%s" % (self.__class__.__name__,
                                              `self.path`, `self.random`, `self.songdbid`)


class getsongsinplaylists(dbrequest):
    """ return all songs store in all playlists """
    def __init__(self, songdbid, random=None):
        self.songdbid = songdbid
        self.random = random

    def __str__(self):
        return "%s(random=%s)->%s" % (self.__class__.__name__, `self.random`, `self.songdbid`)


class requestnextsong(request):
    """ request a song from playlistid. Go back in playlist if previous is set """
    def __init__(self, playlistid, previous=0):
        self.playlistid = playlistid
        self.previous = previous

    def __str__(self):
        return "%s->%s,%s" % (self.__class__.__name__, `self.playlistid`, `self.previous`)


class getplaybackinfo(request):
    """ request info about song currently playing on player playerid """
    def __init__(self, playerid):
        self.playerid = playerid

    def __str__(self):
        return "%s->%s" % (self.__class__.__name__, `self.playerid`)


class requestinput:
    def __init__(self, title, prompt, handler):
        self.title = title
        self.prompt = prompt
        self.handler = handler

    def __str__(self):
        return "%s(%s,%s,%s)" % (self.__class__.__name__,
                              self.title, self.prompt, `self.handler`)


class playlistgetcontents(request):
    pass
