#!/bin/bash
set +e
set +x
echo "# Running Python Testing Programs"
echo "# The tests are collected from test/run_test.py"
if ! test -d debian; then
    echo Please run this script right outside of the debian/ directory.
fi
export PYTHONPATH=$(pwd)/debian/expecttest/
echo ${PYTHONPATH}
FILES_CORE=(
test_autograd
test_modules
test_nn
test_ops
test_ops_gradients
test_ops_jit
test_torch
)
FILES_ALL=(
benchmark_utils/test_benchmark_utils
distributed/test_c10d
distributed/test_c10d_spawn
distributed/test_data_parallel
distributed/test_distributed_fork
distributed/test_distributed_spawn
distributed/test_jit_c10d
distributed/test_nccl
distributions/test_constraints
distributions/test_distributions
test_autograd
test_binary_ufuncs
test_bundled_inputs
test_complex
test_cpp_api_parity
test_cpp_extensions_aot_ninja
test_cpp_extensions_aot_no_ninja
test_cpp_extensions_jit
test_cuda
test_cuda_primary_ctx
test_dataloader
test_datapipe
test_dataset
test_dispatch
test_expecttest
test_foreach
test_indexing
test_jit
test_jit_cuda_fuser
test_linalg
test_logging
test_mkldnn
test_mobile_optimizer
test_modules
test_multiprocessing
test_multiprocessing_spawn
test_native_functions
test_nn
test_numba_integration
test_ops
test_ops_gradients
test_ops_jit
test_optim
test_pruning_op
test_pytree
test_quantization
test_serialization
test_sparse
test_spectral_ops
test_torch
test_type_hints
test_vulkan
test_xnnpack_integration
)
FILES_FINDALL=( $(cd test && find . -type f -name 'test_*.py' | sed -e 's@^./@@g' | sed -e 's@.py$@@g' | sort | uniq) )
FILES=()


# allow us to select the pytest subsets
while [[ $# -gt 0 ]]; do
  case $1 in
    --core)
      FILES=( ${FILES[@]} ${FILES_CORE[@]} )      
      shift
      ;;
    --all)
      FILES=( ${FILES[@]} ${FILES_ALL[@]} )
      shift
      ;;
    --findall)
      FILES=( ${FILES[@]} ${FILES_FINDALL[@]} )
      shift
      ;;
    *)
      echo "Unknown option $1"
      exit 1
      ;;
  esac
done
FILES=( $(echo ${FILES[@]} | sort | uniq) )


echo "# Found" ${#FILES[@]} "tests"
echo "#"
sleep 1

failed=( )
cd test/
for (( i = 0; i < ${#FILES[@]}; i++ )); do
	echo
	echo
	echo "# Py test ${i}/${#FILES[@]} ${FILES[$i]}"
	echo "$(pwd)# /usr/bin/python3 -m pytest ${FILES[$i]}.py -v"
	/usr/bin/python3 -m pytest ${FILES[$i]}.py -v
	if test 0 != $?; then
		failed+=( ${Files[$i]} )
	fi
done

echo
echo "# listing failed tests ..."
for i in ${failed[@]}; do
	echo ${i}
done
