/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEDITUNITDIALOG_H
#define QALCULATEEDITUNITDIALOG_H

#include <kdialogbase.h>

class QLabel;
class KComboBox;
class KLineEdit;
class QCheckBox;
class QPushButton;
class QSpinBox;
class MathStructure;
class QalculateEditNamesDialog;
class Unit;
class QGroupBox;

/**
@author Niklas Knutsson
*/
class QalculateEditUnitDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditUnitDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditUnitDialog();

	Unit *editUnit(QString category = QString::null, Unit *u = NULL);

	QalculateEditNamesDialog *names_edit_dialog;
	Unit *edited_unit;
	KComboBox *categoryCombo, *classCombo, *systemCombo;
	KLineEdit *nameEdit, *titleEdit, *baseEdit, *relationEdit, *inverseRelationEdit;
	QLabel *namesLabel, *exponentLabel, *relationLabel, *inverseRelationLabel;
	QCheckBox *relationExactButton, *hideButton;
	QPushButton *namesButton;
	QSpinBox *exponentBox;
	QGroupBox *grid1, *grid2, *grid3;

public slots:

	void editNames();
	void classChanged(int);
	void nameChanged(const QString&);

protected slots:
	
	void slotHelp();
	void slotOk();

};

#endif
