/***************************************************************************
 $RCSfile: selectpayee.cpp,v $
                             -------------------
    cvs         : $Id: selectpayee.cpp,v 1.6 2005/08/31 05:24:20 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

extern "C" {
#include <aqbanking/country.h>
}

#include "selectpayee.h"
#include "payee.h"
#include "transaction.h"
#include "kbanking.h"
#include "payeelist.h"
#include "editpayee.h"

#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtextbrowser.h>
#include <qmessagebox.h>
#include <qcheckbox.h>

#include <gwenhywfar/debug.h>




SelectPayee::SelectPayee(KBanking *kb,
                         Transaction *t,
                         QWidget* parent,
                         const char* name,
                         bool modal,
                         WFlags fl)
:SelectPayeeUi(parent, name, modal, fl)
,_app(kb)
,_payee(0)
,_transaction(t)
,_aborted(false){
  std::list<std::string>::const_iterator it;
  Payee *p;

  payeeList->setSelectionMode(QListView::Single);
  payeeList->setAllColumnsShowFocus(true);

  if (t) {
    transBrowser->setText(QString::fromUtf8(t->toHtmlInfo().c_str()));
  }
  else {
    transBrowser->hide();
  }
  QObject::connect((QObject*)assignButton,
                   SIGNAL(clicked()),
                   this, SLOT(slotAssignSelected()));
  QObject::connect((QObject*)createButton,
                   SIGNAL(clicked()),
                   this, SLOT(slotNew()));
  QObject::connect((QObject*)editButton,
                   SIGNAL(clicked()),
                   this, SLOT(slotEdit()));
  QObject::connect((QObject*)abortButton,
                   SIGNAL(clicked()),
                   this, SLOT(slotAbort()));
  payeeList->addPayees(_app->getPayees());

  if (t) {
    p=_app->findPayeeByTransactionMatch(t);
    if (!p) {
      if (!(t->getRemoteBankCode().empty()) ||
          !(t->getRemoteAccountNumber().empty())) {
        std::list<Payee*>::const_iterator pit;

        for (pit=_app->getPayees().begin();
             pit!=_app->getPayees().end();
             pit++) {
          if (
              (!((*pit)->bankCode().empty()) &&
               !(t->getRemoteBankCode().empty()))
              ||
              (!((*pit)->accountNumber().empty()) &&
               !(t->getRemoteAccountNumber().empty()))
             ){
            bool probable=true;

            if (!(t->getRemoteBankCode().empty())) {
              if (!((*pit)->bankCode().empty()))
                probable=(0==strcasecmp(t->getRemoteBankCode().c_str(),
                                        (*pit)->bankCode().c_str()));
            }
            if (probable) {
              if (!(t->getRemoteAccountNumber().empty())) {
                if (!((*pit)->accountNumber().empty()))
                  probable=(0==strcasecmp(t->getRemoteAccountNumber().c_str(),
                                          (*pit)->accountNumber().c_str()));
              }
            }
            if (probable) {
              DBG_NOTICE(0, "Match by bank account");
              p=*pit;
              break;
            }
          }
        } // for
      } // if remote bankCode and accountNumber available
    } // if !p
    if (p) {
      payeeList->selectPayee(p->id().c_str(), true);
    }
  }
}



SelectPayee::~SelectPayee(){
}



void SelectPayee::init() {
  GWEN_DB_NODE *db;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                      "gui/dlgs/Selectpayee");
  if (db) {
    int i, j;
    const char *p;
    int x, y;

    x=GWEN_DB_GetIntValue(db, "width", 0, -1);
    y=GWEN_DB_GetIntValue(db, "height", 0, -1);
    if (x!=-1 && y!=-1) {
      DBG_DEBUG(0, "Resizing to %d/%d", x, y);
      resize(x, y);
    }
    x=GWEN_DB_GetIntValue(db, "x", 0, -1);
    y=GWEN_DB_GetIntValue(db, "y", 0, -1);
    if (x!=-1 && y!=-1)
      move(x, y);

    p=GWEN_DB_GetCharValue(db, "sortOrder", 0, "ascending");
    if (p) {
      if (strcasecmp(p, "ascending")==0)
        payeeList->setSortOrder(Qt::Ascending);
      else
        if (strcasecmp(p, "descending")==0)
          payeeList->setSortOrder(Qt::Descending);
    }
    i=GWEN_DB_GetIntValue(db, "sortColumn", 0, -1);
    if (i!=-1)
      payeeList->setSortColumn(i);

    /* found settings */
    for (i=0; i<payeeList->columns(); i++) {
      payeeList->setColumnWidthMode(i, QListView::Manual);
      j=GWEN_DB_GetIntValue(db, "columns", i, -1);
      if (j!=-1)
        payeeList->setColumnWidth(i, j);
    } /* for */
  } /* if settings */
}


void SelectPayee::fini() {
  GWEN_DB_NODE *db;
  int i, j;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db,
                      GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                      "gui/dlgs/SelectPayee");

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "x", x());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "y", y());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "width", width());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "height", height());

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                      "sortColumn", payeeList->sortColumn());
  switch(payeeList->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "descending");
    break;
  default:
    break;
  }

  for (i=0; i<payeeList->columns(); i++) {
    j=payeeList->columnWidth(i);
    GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                        "columns", j);
  } /* for */
}



Payee *SelectPayee::selectedPayee(){
  return _payee;
}



void SelectPayee::slotAssignSelected(){
  std::list<Payee*> pl;
  pl=payeeList->getSelectedPayees();
  if (pl.empty()) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No payee selected."
                            "</qt>"),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }
  _payee=pl.front();
  QDialog::accept();
}



void SelectPayee::slotNew(){
  Payee *p;

  p=new Payee();
  if (_transaction) {
    std::list<std::string>::const_iterator sit;
    std::string s;
    GWEN_DB_NODE *dbRule;

    // preset payee as far as possible
    p->setAccountNumber(_transaction->getRemoteAccountNumber());
    p->setBankCode(_transaction->getRemoteBankCode());
    for (sit=_transaction->getRemoteName().begin();
         sit!=_transaction->getRemoteName().end();
         sit++) {
      if (!s.empty())
        s+=" ";
      s+=*sit;
    }
    p->setName(s);
    dbRule=GWEN_DB_Group_new("rule");
    GWEN_DB_SetIntValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                        "data/account/allAccounts", 1);
    GWEN_DB_SetIntValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                        "data/payee/allPayees", 1);
    GWEN_DB_SetIntValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                        "data/category/allCategories", 1);

    if (!s.empty()) {
      GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                           "data/payee/compare/operation",
                           "contains");
      GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                           "data/payee/compare/argument", s.c_str());
    }
    else {
      sit=_transaction->getPurpose().begin();
      if (sit!=_transaction->getPurpose().end()) {
        GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                             "data/test/compare/operation",
                             "contains");
        GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                             "data/text/compare/argument", (*sit).c_str());
      }
    }
    GWEN_DB_AddGroup(p->rules(), dbRule);

    // setup country
    s=_transaction->getRemoteCountry();
    if (s.empty())
      s="280"; // preset to Germany
    if (!s.empty()) {
      int i;
      const AB_COUNTRY *cnt;

      if (1!=sscanf(s.c_str(), "%d", &i))
        i=280; // preset to Germany
      cnt=AB_Banking_FindCountryByNumeric(_app->getCInterface(), i);
      if (cnt) {
        const char *cn;

        cn=AB_Country_GetLocalName(cnt);
        if (cn)
          p->setCountry(cn);
      }
    }
  }

  EditPayee ep(_app, p, false, this);
  if (ep.exec()!=QDialog::Accepted) {
    delete p;
  }
  else {
    if (!_app->addPayee(p)) {
      DBG_ERROR(0, "Could not add payee");
      QMessageBox::critical(0,
                            tr("Error"),
                            tr("Error adding the payee. "
                               "Please see console log."),
                            tr("Dismiss"), 0, 0, 0);
      delete p;
    }
    else {
      payeeList->clear();
      payeeList->addPayees(_app->getPayees());
      if (_transaction) {
        p=_app->findPayeeByTransactionMatch(_transaction);
        if (p) {
          payeeList->selectPayee(p->id().c_str(), true);
        }
      }
    }
  }
}



void SelectPayee::slotEdit(){
  std::list<Payee*> pl;
  Payee *p;

  pl=payeeList->getSelectedPayees();
  if (pl.empty()) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No payee selected."
                            "</qt>"),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }
  p=pl.front();

  EditPayee ep(_app, p, false, this);
  if (ep.exec()==QDialog::Accepted) {
    payeeList->clear();
    payeeList->addPayees(_app->getPayees());
    if (_transaction) {
      p=_app->findPayeeByTransactionMatch(_transaction);
      if (p) {
        payeeList->selectPayee(p->id().c_str(), true);
      }
    }
  }
}



void SelectPayee::slotAbort(){
  _aborted=true;
  reject();
}



Payee *SelectPayee::selectPayee(KBanking *kb,
                                const QString &title,
                                const QString &text,
                                QWidget* parent) {
  SelectPayee sp(kb, 0, parent, "selectPayee", true);

  sp.againCheckBox->hide();
  sp.init();
  sp.payeeList->ensureSelectionVisible();
  if (!title.isEmpty())
    sp.setCaption(title);
  if (!text.isEmpty())
    sp.titleLabel->setText(text);
  else
    sp.titleLabel->hide();
  if (sp.exec()==QDialog::Accepted) {
    sp.fini();
    return sp.selectedPayee();
  }
  sp.fini();
  return 0;
}



Payee *SelectPayee::assignPayee(KBanking *kb,
                                Transaction *t,
                                bool &aborted,
                                bool &askNoMore,
                                QWidget* parent) {
  SelectPayee sp(kb, t, parent, "selectPayee", true);

  aborted=false;
  sp.init();
  sp.assignButton->setText(tr("Assign"));
  sp.payeeList->ensureSelectionVisible();
  if (sp.exec()==QDialog::Accepted) {
    sp.fini();
    return sp.selectedPayee();
  }
  aborted=sp._aborted;
  askNoMore=sp.againCheckBox->isChecked();
  sp.fini();
  return 0;
}



Payee *SelectPayee::assignSinglePayee(KBanking *kb,
                                      Transaction *t,
                                      bool &aborted,
                                      QWidget* parent) {
  SelectPayee sp(kb, t, parent, "selectPayee", true);

  sp.againCheckBox->hide();
  aborted=false;
  sp.init();
  sp.assignButton->setText(tr("Assign"));
  sp.payeeList->ensureSelectionVisible();
  if (sp.exec()==QDialog::Accepted) {
    sp.fini();
    return sp.selectedPayee();
  }
  aborted=sp._aborted;
  sp.fini();
  return 0;
}










