/***************************************************************************
 $RCSfile: summaryreport.h,v $
                             -------------------
    cvs         : $Id: summaryreport.h,v 1.2 2005/09/01 07:27:38 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef QBANKMANAGER_SUMMARYREPORT_H
#define QBANKMANAGER_SUMMARYREPORT_H


#include "report.h"


class SummaryReport: public Report {
protected:
  QString writeRow(GWEN_DB_NODE *dbProfile,
                   const QString &dt,
                   const AB_VALUE *vIncome,
                   const AB_VALUE *vExpense,
                   const AB_VALUE *vBalance,
                   const AB_VALUE *vBalanceSum,
                   bool fat);

  QString handleDay(GWEN_DB_NODE *dbProfile,
                    QWidget *parent,
                    Report::Day *dy,
                    AB_VALUE *vMonthIncome,
                    AB_VALUE *vMonthExpense,
                    AB_VALUE *vBalanceSum,
                    bool drawAlso);
  QString handleMonth(GWEN_DB_NODE *dbProfile,
                      QWidget *parent,
                      Report::Month *m,
                      AB_VALUE *vAccountIncome,
                      AB_VALUE *vAccountExpense,
                      AB_VALUE *vAccountBalanceSum);
  QString handleAccount(GWEN_DB_NODE *dbProfile,
                        QWidget *parent,
                        Report::AccountData *ad);

public:
  SummaryReport(KBanking *app);
  ~SummaryReport();

  QString shortDescription();
  QString longDescription();

  bool initProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);
  bool editProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);
  bool useProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);

};



#endif // QBANKMANAGER_SUMMARYREPORT_H

