/***************************************************************************
 $RCSfile: transactionview.cpp,v $
                             -------------------
    cvs         : $Id: transactionview.cpp,v 1.20 2005/08/31 07:34:26 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "transactionview.h"
#include "selectpayee.h"
#include "editpayee.h"
#include "selectcategory.h"
#include "editcategory.h"

#include <aqbanking/jobgetbalance.h>
#include "kbanking.h"
#ifdef WIN32
# define strcasecmp stricmp
#endif

#include <qevent.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qstatusbar.h>
#include <qlistview.h>
#include <qspinbox.h>
#include <qapplication.h>

#include <gwenhywfar/debug.h>



#define BUTTON_WIDTH 110


TransactionView::TransactionView(Account *a,
                                 bool shortList,
                                 QWidget* parent,
                                 const char* name,
                                 WFlags fl)
:TransactionViewUi(parent, name, fl)
,_app(0)
,_account(a)
,_currentItem(0)
,_shortList(shortList)
,_tname(0) {
  assert(a);
  _app=(KBanking*)(a->getApi());
  transactionListView->setShortList(shortList);
  transactionListView->setApp(_app);
  workingLabel->setHidden(true);

  QObject::connect((QObject*)detailsButton, SIGNAL(clicked()),
                   this, SLOT(slotDetails()));
  QObject::connect((QObject*)refreshButton, SIGNAL(clicked()),
                   this, SLOT(slotUpdated()));
  QObject::connect((QObject*)transactionListView,
                   SIGNAL(currentChanged(QListViewItem*)),
                   this, SLOT(slotCurrentChanged(QListViewItem*)));

  QObject::connect((QObject*)setPayeeButton, SIGNAL(clicked()),
                   this, SLOT(slotSetPayee()));
  QObject::connect((QObject*)openPayeeButton, SIGNAL(clicked()),
                   this, SLOT(slotOpenPayee()));
  QObject::connect((QObject*)setCategoryButton, SIGNAL(clicked()),
                   this, SLOT(slotSetCategory()));
  QObject::connect((QObject*)openCategoryButton, SIGNAL(clicked()),
                   this, SLOT(slotOpenCategory()));

}



TransactionView::TransactionView(KBanking *app,
                                 const std::list<RefPointer<Transaction> > &l,
                                 const char *tname,
                                 bool shortList,
                                 QWidget* parent,
                                 const char* name,
                                 WFlags fl)
:TransactionViewUi(parent, name, fl)
,_app(app)
,_account(0)
,_currentItem(0)
,_shortList(shortList)
,_tname(tname)
,_transactions(l) {
  transactionListView->setShortList(shortList);
  transactionListView->setApp(_app);
  workingLabel->setHidden(true);
  timeSpanBox->setHidden(true);

  QObject::connect((QObject*)detailsButton, SIGNAL(clicked()),
                   this, SLOT(slotDetails()));
  QObject::connect((QObject*)refreshButton, SIGNAL(clicked()),
                   this, SLOT(slotUpdated()));
  QObject::connect((QObject*)transactionListView,
                   SIGNAL(currentChanged(QListViewItem*)),
                   this, SLOT(slotCurrentChanged(QListViewItem*)));

  QObject::connect((QObject*)setPayeeButton, SIGNAL(clicked()),
                   this, SLOT(slotSetPayee()));
  QObject::connect((QObject*)openPayeeButton, SIGNAL(clicked()),
                   this, SLOT(slotOpenPayee()));
  QObject::connect((QObject*)setCategoryButton, SIGNAL(clicked()),
                   this, SLOT(slotSetCategory()));
  QObject::connect((QObject*)openCategoryButton, SIGNAL(clicked()),
                   this, SLOT(slotOpenCategory()));
}



TransactionView::~TransactionView(){
}


bool TransactionView::init(){
  GWEN_DB_NODE *db;
  std::string s;
  int i, j;

  transactionListView->beginModify();

  db=_app->getAppData();
  if (db) {
    db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                        "gui/views/transactionview");
    if (db) {
      if (_account) {
	s=_account->getBankCode();
	if (!s.empty()) {
	  db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
			      s.c_str());
	  if (db) {
	    s=_account->getAccountNumber();
	    if (!s.empty()) {
	      db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
				  s.c_str());
	    }
	  }
	}
      }
      else {
        if (_tname)
          db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                              _tname);
        else
          db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                              "generic");
      }

      if (db) {
	int w;
	int h;
	const char *p;

	/* found settings */
	p=GWEN_DB_GetCharValue(db, "sortOrder", 0, "ascending");
	if (p) {
	  if (strcasecmp(p, "ascending")==0)
	    transactionListView->setSortOrder(Qt::Ascending);
	  else
	    if (strcasecmp(p, "descending")==0)
	      transactionListView->setSortOrder(Qt::Descending);
	}
	i=GWEN_DB_GetIntValue(db, "sortColumn", 0, -1);
	if (i!=-1)
	  transactionListView->setSortColumn(i);
	w=GWEN_DB_GetIntValue(db, "width", 0, 640);
	h=GWEN_DB_GetIntValue(db, "height", 0, 480);
	resize(w, h);
	for (i=0; i<transactionListView->columns(); i++) {
	  transactionListView->setColumnWidthMode(i, QListView::Manual);
	  j=GWEN_DB_GetIntValue(db, "columns", i, -1);
	  if (j!=-1)
	    transactionListView->setColumnWidth(i, j);
	} /* for */
	daySpin->setValue(GWEN_DB_GetIntValue(db, "numDays", 0, 30));
      } // db
    } // if transaction view setting
  } // if application settings
  slotUpdated();
  transactionListView->endModify();
  return true;
}



bool TransactionView::fini(){
  GWEN_DB_NODE *db;
  int i, j;
  std::string s;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT,
                      "gui/views/transactionview");
  assert(db);
  if (_account) {
    s=_account->getBankCode();
    if (!s.empty()) {
      db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_DEFAULT,
			  s.c_str());
      assert(db);
      s=_account->getAccountNumber();
      if (!s.empty()) {
	db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
			    s.c_str());
	assert(db);
      }
    }
  } // if _account
  else {
    if (_tname)
      db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                          _tname);
    else
      db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                          "generic");
  }
  assert(db);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "width", width());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "height", height());

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "sortColumn", transactionListView->sortColumn());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "numDays", daySpin->value());

  switch(transactionListView->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
			 "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
			 "sortOrder", "descending");
    break;
  default:
    break;
  }

  for (i=0; i<transactionListView->columns(); i++) {
    j=transactionListView->columnWidth(i);
    GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
			"columns", j);
  } /* for */

  return true;
}


void TransactionView::slotUpdated() {
  std::list<RefPointer<Transaction> > l;
  int n;
  GWEN_TIME *cti;
  GWEN_TIME *ti;
  GWEN_TYPE_UINT32 secs;
  bool res;
  bool h1;
  bool h2;

  transactionListView->beginModify();
  h1=transactionListView->isHidden();
  h2=workingLabel->isHidden();
  workingLabel->setHidden(false);
  transactionListView->setHidden(true);
  qApp->processEvents();

  _currentItem=0;
  transactionListView->clear();
  if (_account) {
    n=daySpin->value();
    cti=GWEN_CurrentTime();
    secs=GWEN_Time_Seconds(cti);
    secs-=(n*60*60*24);
    ti=GWEN_Time_fromSeconds(secs);

    res=_account->loadTransactions(ti, cti, l);
    GWEN_Time_free(ti);
    GWEN_Time_free(cti);
    if (!res) {
      DBG_ERROR(0, "Error loading transactions");
    }

    transactionListView->addTransactions(l);
  }
  else {
    transactionListView->addTransactions(_transactions);
  }
  transactionListView->setCurrentItem(transactionListView->firstChild());
  slotCurrentChanged(transactionListView->firstChild());
  transactionListView->setFocus();

  transactionListView->setHidden(h1);
  workingLabel->setHidden(h2);
  transactionListView->endModify();
  qApp->processEvents();
}



void TransactionView::slotDetails() {
}



void TransactionView::slotSetPayee() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;
  Payee *payee;
  bool aborted;
  Account *a;

  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(0,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }

  tp=tl.front();

  a=_app->findAccount(tp.ref().getLocalBankCode().c_str(),
                      tp.ref().getLocalAccountNumber().c_str());
  if (!a)
    a=_account;
  if (!a) {
    QMessageBox::critical(0,
                          tr("Selection-Error"),
                          tr("Transactions in this view can not be saved."),
                          tr("Dismiss"), 0, 0, 0);
    return;
  }

  payee=SelectPayee::assignSinglePayee(_app, tp.ptr(), aborted, this);
  if (payee) {
    tp.ref().setPayee(payee->id());
    if (!a->saveTransaction(tp.ptr())) {
      DBG_ERROR(0, "Could not save transaction");
      QMessageBox::critical(0,
                            tr("Storage-Error"),
                            tr("The modified transaction could not be saved"),
                            tr("Dismiss"), 0, 0, 0);
      return;
    }
    else {
      tp.ref().setModified(false);
    }
    transactionListView->redrawSelected();
    _app->flagStaff()->payeesUpdated();
  }

}



void TransactionView::slotOpenPayee() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;
  std::string pname;
  Payee *payee;

  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(0,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }

  tp=tl.front();
  pname=tp.ref().getPayee();
  if (pname.empty()) {
    QMessageBox::warning(0,
                         tr("No Payee"),
                         tr("The selected transaction has no payee set."),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }
  payee=_app->findPayeeById(pname.c_str());
  if (!payee) {
    QMessageBox::warning(0,
                         tr("Payee not found"),
                         tr("The selected transaction has an unknown payee."),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }
  EditPayee ep(_app, payee, false, this, "EditPayee", true);
  if (ep.exec()==QDialog::Accepted) {
    _app->flagStaff()->payeesUpdated();
    transactionListView->redrawSelected();
  }
}



void TransactionView::slotSetCategory() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;
  Category *cat;
  bool aborted;
  Account *a;

  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(0,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }

  tp=tl.front();

  a=_app->findAccount(tp.ref().getLocalBankCode().c_str(),
                      tp.ref().getLocalAccountNumber().c_str());
  if (!a)
    a=_account;
  if (!a) {
    QMessageBox::critical(0,
                          tr("Selection-Error"),
                          tr("Transactions in this view can not be saved."),
                          tr("Dismiss"), 0, 0, 0);
    return;
  }

  cat=SelectCategory::assignSingleCategory(_app, tp.ptr(), aborted, this);
  if (cat) {
    tp.ref().setCategory(cat->getId());
    if (!a->saveTransaction(tp.ptr())) {
      DBG_ERROR(0, "Could not save transaction");
      QMessageBox::critical(0,
                            tr("Storage-Error"),
                            tr("The modified transaction could not be saved"),
                            tr("Dismiss"), 0, 0, 0);
      return;
    }
    else {
      tp.ref().setModified(false);
    }
    transactionListView->redrawSelected();
    _app->flagStaff()->categoriesUpdated();
  }

}



void TransactionView::slotOpenCategory() {
  std::list<RefPointer<Transaction> > tl;
  RefPointer<Transaction> tp;
  std::string pname;
  Category *cat;

  tl=transactionListView->getSelectedTransactions();
  if (tl.empty()) {
    QMessageBox::warning(0,
                         tr("No Selection"),
                         tr("Please select a transaction first."),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }

  tp=tl.front();
  pname=tp.ref().getCategory();
  if (pname.empty()) {
    QMessageBox::warning(0,
                         tr("No Category"),
                         tr("The selected transaction has no cat set."),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }
  cat=_app->findCategoryById(pname.c_str());
  if (!cat) {
    QMessageBox::warning(0,
                         tr("Category not found"),
                         tr("The selected transaction has an unknown cat."),
                         tr("Dismiss"), 0, 0, 0);
    return;
  }
  if (EditCategory::editCategory(_app, cat, this)) {
    _app->flagStaff()->categoriesUpdated();
    transactionListView->redrawSelected();
  }
}



void TransactionView::slotCurrentChanged(QListViewItem *item) {
  if (_shortList) {
    if (_currentItem)
      _currentItem->redrawItem(false);
    _currentItem=0;
    if (item) {
      TransactionListViewItem *entry;
      entry=dynamic_cast<TransactionListViewItem*>(item);
      if (entry) {
        _currentItem=entry;
        _currentItem->redrawItem(true);
      }
    }
  } // if _shortList
}






