/***************************************************************************
 $RCSfile: accountlist.h,v $
                             -------------------
    cvs         : $Id: accountlist.h,v 1.5 2005/06/13 20:00:09 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef KBANKING_ACCOUNTLIST_H
#define KBANKING_ACCOUNTLIST_H


#include <qlistview.h>
#include <aqbanking/account.h>

#include <list>


class AccountListView;
class AccountListViewItem;

#include "account.h"


class AccountListViewItem: public QListViewItem {
private:
  Account *_account;

  void _populate();

public:
  AccountListViewItem(AccountListView *parent,
                      Account *acc);
  AccountListViewItem(AccountListView *parent,
                      QListViewItem *after,
                      Account *acc);
  AccountListViewItem(const AccountListViewItem &item);

  virtual ~AccountListViewItem();

  Account *getAccount();

  QString key(int column, bool ascending) const;

};



class AccountListView: public QListView {
private:
public:
  AccountListView(QWidget *parent=0, const char *name=0);
  virtual ~AccountListView();

  void addAccount(Account *acc);
  void addAccounts(const std::list<Account*> &accs);

  Account *getCurrentAccount();
  std::list<Account*> getSelectedAccounts();
  void selectAccounts(const char *bankCode,
                      const char *accountId,
                      bool s);
};


#endif /* KBANKING_ACCOUNTLIST_H */

