/***************************************************************************
 $RCSfile: payee.h,v $
                             -------------------
    cvs         : $Id: payee.h,v 1.1 2005/02/23 02:15:33 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef KBANKING_PAYEE_H
#define KBANKING_PAYEE_H


class Payee;


#include <string>
#include <list>

#include <gwenhywfar/db.h>
#include <aqbanking/value.h>


class Payee {
private:
  std::string _id;
  std::string _name;
  std::string _street;
  std::string _zipCode;
  std::string _city;
  std::string _state;
  std::string _country;
  std::string _phone;
  std::string _fax;
  std::string _email;
  std::string _bankCode;
  std::string _accountNumber;
  GWEN_DB_NODE *_rules;
  AB_VALUE *_inValue;
  AB_VALUE *_outValue;

public:
  Payee(const std::string &id="");
  ~Payee();
  bool toDb(GWEN_DB_NODE *db) const ;
  bool fromDb(GWEN_DB_NODE *db);

  const std::string &id() const { return _id;};
  void setId(const std::string &s) { _id=s; };

  const std::string &name() const { return _name; };
  void setName(const std::string &s) { _name=s; };

  const std::string &street() const { return _street; };
  void setStreet(const std::string &s) { _street=s; };

  const std::string &zipCode() const { return _zipCode; };
  void setZipCode(const std::string &s) { _zipCode=s; };

  const std::string &city() const { return _city; };
  void setCity(const std::string &s) { _city=s; };

  const std::string &state() const { return _state; };
  void setState(const std::string &s) { _state=s; };

  const std::string &country() const { return _country; };
  void setCountry(const std::string &s) { _country=s; };

  const std::string &phone() const { return _phone; };
  void setPhone(const std::string &s) { _phone=s; };

  const std::string &fax() const { return _fax; };
  void setFax(const std::string &s) { _fax=s; };

  const std::string &email() const { return _email; };
  void setEmail(const std::string &s) { _email=s; };

  const std::string &bankCode() const { return _bankCode; };
  void setBankCode(const std::string &s) { _bankCode=s; };

  const std::string &accountNumber() const { return _accountNumber; };
  void setAccountNumber(const std::string &s) { _accountNumber=s; };

  GWEN_DB_NODE *rules() const { return _rules; };

  void resetValues();
  bool addInValue(const AB_VALUE *v);
  bool addOutValue(const AB_VALUE *v);
  const AB_VALUE *inValue() const { return _inValue;};
  const AB_VALUE *outValue() const { return _outValue;};

};






#endif




