/***************************************************************************
 $RCSfile: rtlist.cpp,v $
                             -------------------
    cvs         : $Id: rtlist.cpp,v 1.1 2006/03/10 02:20:53 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rtlist.h"

#include <qsimplerichtext.h>
#include <qpainter.h>
#include <qheader.h>

#include <gwenhywfar/debug.h>



RichTextListViewItem::RichTextListViewItem(RichTextListView *parent)
:QListViewItem(parent), _id(0) {
  if (parent)
    _id=parent->nextId();
}



RichTextListViewItem::RichTextListViewItem(RichTextListView *parent,
                                           RichTextListViewItem *after)
:QListViewItem(parent, after), _id(0) {
  if (parent)
    _id=parent->nextId();
}



RichTextListViewItem::~RichTextListViewItem() {
}



void RichTextListViewItem::setText(int col, const QString &text) {
  QValueList<Column>::size_type size;

  size=_columns.size();
  if (col>=(int)size) {
    for (unsigned int i=0; i<(col-size)+1; i++) {
      /* append columns */
      _columns.push_back(Column());
    }
  }
  Column &column=_columns[col];
  if (column.text!=text) {
    column.text=text;
    column.width=0;
    column.height=0;
    repaint();
  }
}



QString RichTextListViewItem::text(int col) const {
  if (col>=(int)_columns.size()) {
    static QString emptyString;
    //DBG_ERROR(0, "Column %d out of range", col);
    return emptyString;
  }
  return _columns[col].text;
}



unsigned long RichTextListViewItem::id() const {
  return _id;
}



RefPointer<QSimpleRichText> RichTextListViewItem::_prepareRichText(int col) {
  RefPointer<QSimpleRichText> rt;

  //DBG_ERROR(0, "Preparing richtext for column %d  (%p)", col, this);
  setupColumn(col);

  if (col>=(int)_columns.size()) {
    DBG_ERROR(0, "Column %d out of range", col);
    return 0;
  }
  Column &column=_columns[col];
  rt=new QSimpleRichText(column.text, listView()->font());
  column.width=listView()->columnWidth(col)-(2*listView()->itemMargin());
  rt.ref().setWidth(column.width);
  column.height=rt.ref().height();

  _adjustHeight();
  return rt;
}



void RichTextListViewItem::_adjustHeight() {
  unsigned int h;
  unsigned int i;

  h=0;
  for (i=0; i<_columns.size(); i++) {
    if (h<_columns[i].height)
      h=_columns[i].height;
  }
  setHeight(h);
}



void RichTextListViewItem::paintCell(QPainter *pnt,
                                     const QColorGroup & cg,
                                     int col,
                                     int width,
                                     int align) {
  RefPointer<QSimpleRichText> rt;
  QBrush br;

  //DBG_ERROR(0, "Drawing column %d  of row %d (%p)", col, itemPos(), this);

  if (col>=(int)_columns.size()) {
    DBG_ERROR(0, "Column %d out of range", col);
    return;
  }

  rt=_prepareRichText(col);
  if (rt.isValid()) {
    if (isSelected()) {
      br=QBrush(QColor("light blue"));
    }
    else {
      if (!_colour.isEmpty()) {
        br=QBrush(QColor(_colour));
      }
      else {
        //if (_id & 1)
        //  br=QBrush(QColor("light yellow"));
        //else
        br=cg.brush(QColorGroup::Midlight);
      }
    }

    rt.ref().draw(pnt,
                  listView()->itemMargin(),
                  listView()->itemMargin(),
                  QRect(0, 0, width, height()),
                  cg, &br);
  }
}



int RichTextListViewItem::width(const QFontMetrics &,
                                const QListView *,
                                int col) const {
  if (col>=(int)_columns.size()) {
    DBG_WARN(0, "Column %d out of range", col);
    return 0;
  }
  const Column &column=_columns[col];
  return column.width;
}



void RichTextListViewItem::setup() {
  RichTextListView *lv;
  unsigned int h;
  unsigned int i;

  lv=dynamic_cast<RichTextListView *>(listView());
  assert(lv);
  h=2*QFontMetrics(listView()->font()).height();

  switch(lv->drawMode()) {
  case RichTextListView::DrawMode_Slow: {
    unsigned int i;

    h=0;
    for (i=0; i<_columns.size(); i++) {
      RefPointer<QSimpleRichText> rt;

      rt=_prepareRichText(i);
      if (rt.isValid()) {
        if (h<_columns[i].height)
          h=_columns[i].height;
      }
    }
    break;
  }

  case RichTextListView::DrawMode_Fast: {
    int maxLen;
    int longestCol;
    RefPointer<QSimpleRichText> rt;

    /* determine column with most data*/
    maxLen=0;
    longestCol=-1;
    for (i=0; i<_columns.size(); i++) {
      int l=_columns[i].text.length();
      if (maxLen<l) {
        maxLen=l;
        longestCol=i;
      }
    }

    /* determine height */
    if (longestCol!=-1) {
      rt=_prepareRichText(longestCol);
      if (rt.isValid())
        h=_columns[longestCol].height;
    }

    break;
  }

  default:
  case RichTextListView::DrawMode_Fastest:
    for (i=0; i<_columns.size(); i++) {
      _columns[i].width=listView()->columnWidth(i);
      _columns[i].height=h;

  }
  }

  h+=2*listView()->itemMargin();

  /* set height and width in column data */
  for (i=0; i<_columns.size(); i++) {
    _columns[i].width=listView()->columnWidth(i);
    _columns[i].height=h;
  }

  /* set hegiht in item */
  widthChanged();
  setHeight(h);
}



QString RichTextListViewItem::key(int column, bool ascending) const {
  return text(column);
}



void RichTextListViewItem::setColour(const QString &c) {
  if (_colour!=c) {
    _colour=c;
    repaint();
  }
}



void RichTextListViewItem::setupColumn(int col) {
}









RichTextListView::RichTextListView(QWidget *parent, const char *name)
:QListView(parent, name), _lastId(0), _drawMode(DrawMode_Fastest) {
  QObject::connect(header(), SIGNAL(sizeChange(int, int, int)),
                   this, SLOT(slotHeaderChanged(int, int, int)));
}



RichTextListView::~RichTextListView() {
}



unsigned long RichTextListView::nextId() {
  return ++_lastId;
}



void RichTextListView::setDrawMode(RichTextListView::DrawMode dm) {
  _drawMode=dm;
}



RichTextListView::DrawMode RichTextListView::drawMode() const {
  return _drawMode;
}



void RichTextListView::slotHeaderChanged(int section,
                                         int oldSize,
                                         int newSize) {
  RichTextListViewItem *entry;

  // Create an iterator and give the listview as argument
  QListViewItemIterator it(this);
  // iterate through all items of the listview
  for (;it.current();++it) {
    entry=dynamic_cast<RichTextListViewItem*>(it.current());
    if (entry) {
      entry->repaint();
    }
  } // for
}












