/***************************************************************************
 $RCSfile: stolist.cpp,v $
                             -------------------
    cvs         : $Id: stolist.cpp,v 1.3 2005/10/02 14:05:27 cstim Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "stolist.h"
#include <assert.h>
#include <qstring.h>
#include <qpainter.h>
#include <qdatetime.h>
#include <qheader.h>

#include <gwenhywfar/debug.h>


StandingOrderListViewItem::StandingOrderListViewItem(StandingOrderListView *parent,
                                           RefPointer<StandingOrder> t)
:QListViewItem(parent)
,_sto(t){
  assert(parent);
  _populate();
}



StandingOrderListViewItem::StandingOrderListViewItem(const StandingOrderListViewItem &item)
:QListViewItem(item) {
  _sto=item._sto;
}



StandingOrderListViewItem::StandingOrderListViewItem(StandingOrderListView *parent,
                                           QListViewItem *after,
                                           RefPointer<StandingOrder> t)
:QListViewItem(parent, after)
,_sto(t){
  _populate();
}



StandingOrderListViewItem::~StandingOrderListViewItem(){
}



void StandingOrderListViewItem::setColour(const QString &c){
  _colour=c.latin1();
  repaint();
}



RefPointer<StandingOrder> StandingOrderListViewItem::getStandingOrder(){
  return _sto;
}



void StandingOrderListViewItem::redrawItem() {
  int i;

  for (i=0; i<STANDINGORDER_LISTVIEW_COLUMNS; i++) {
    delete _cell[i];
    _cell[i]=0;
  }

  _populate();
  setup();
}



void StandingOrderListViewItem::_populate() {
  QString tmp;
  int i;
  const std::list<std::string> sl;
  std::list<std::string>::const_iterator it;
  int ht;
  const GWEN_TIME *ti;
  const AB_VALUE *v;

  i=0;

  for (i=0; i<STANDINGORDER_LISTVIEW_COLUMNS; i++)
    _cell[i]=0;

  i=0;
  ht=0;

  // next execution date
  tmp="<qt>";
  ti=_sto.ref().getNextExecutionDate();
  if (ti) {
    int year, month, day;

    if (!GWEN_Time_GetBrokenDownDate(ti, &day, &month, &year)) {
      QDate t;

      t=QDate(year, month+1, day);
      tmp+=t.toString();
    }
  }
  tmp+="</qt>";
  _cell[i]=new QSimpleRichText(tmp, listView()->font());
  _cell[i]->setWidth(listView()->columnWidth(i));
  ht=(ht<_cell[i]->height())?_cell[i]->height():ht;
  i++;

  // institute
  tmp="<qt>";
  tmp+=QString::fromUtf8(_sto.ref().getRemoteBankCode().c_str());
  tmp+="</qt>";
  _cell[i]=new QSimpleRichText(tmp, listView()->font());
  _cell[i]->setWidth(listView()->columnWidth(i));
  ht=(ht<_cell[i]->height())?_cell[i]->height():ht;
  i++;

  // account
  tmp="<qt>";
  tmp+=QString::fromUtf8(_sto.ref().getRemoteAccountNumber().c_str());
  tmp+="</qt>";
  _cell[i]=new QSimpleRichText(tmp, listView()->font());
  _cell[i]->setWidth(listView()->columnWidth(i));
  ht=(ht<_cell[i]->height())?_cell[i]->height():ht;
  i++;

  // other name
  tmp="<qt>";
  for (it=_sto.ref().getRemoteName().begin();
       it!=_sto.ref().getRemoteName().end();
       it++) {
    tmp+=QString::fromUtf8((*it).c_str());
    tmp+="<br>";
  } // for

  // description
  for (it=_sto.ref().getPurpose().begin();
       it!=_sto.ref().getPurpose().end();
       it++) {
    tmp+="<br>";
    tmp+=QString::fromUtf8((*it).c_str());
  } // for

  tmp+="</qt>";
  _cell[i]=new QSimpleRichText(tmp, listView()->font());
  _cell[i]->setWidth(listView()->columnWidth(i));
  ht=(ht<_cell[i]->height())?_cell[i]->height():ht;
  i++;

  // value
  tmp="<qt>";
  v=_sto.ref().getValue();
  if (v) {
    tmp+=QString::number(AB_Value_GetValue(v), 'f', 2);
    tmp+=" ";
    tmp+=QString::fromUtf8(AB_Value_GetCurrency(v));
  }
  tmp+="</qt>";
  _cell[i]=new QSimpleRichText(tmp, listView()->font());
  _cell[i]->setWidth(listView()->columnWidth(i));
  ht=(ht<_cell[i]->height())?_cell[i]->height():ht;
  i++;

  // last execution date
  tmp="<qt>";
  ti=_sto.ref().getLastExecutionDate();
  if (ti) {
    int year, month, day;

    if (!GWEN_Time_GetBrokenDownDate(ti, &day, &month, &year)) {
      QDate t;

      t=QDate(year, month+1, day);
      tmp+=t.toString();
    }
  }
  tmp+="</qt>";
  _cell[i]=new QSimpleRichText(tmp, listView()->font());
  _cell[i]->setWidth(listView()->columnWidth(i));
  ht=(ht<_cell[i]->height())?_cell[i]->height():ht;
  i++;


  _ht=ht;
  setHeight(ht);

  //_colour="light green";
}



// return string for sort
QString StandingOrderListViewItem::key(int column, bool ascending) const{
  QString result;

  result="";

  switch(column) {
  case 0: { // nextExecutionDate
    const GWEN_TIME *ti;

    ti=_sto.ref().getNextExecutionDate();
    if (ti) {
      result=QString::number(GWEN_Time_Seconds(ti));
    }
    break;
  }

  case 1: // institute
    result=_sto.ref().getRemoteBankCode().c_str();
    break;

  case 2: // account
    result=_sto.ref().getRemoteAccountNumber().c_str();
    break;

  case 3: { // othername
    std::list<std::string>::const_iterator it;

    for (it=_sto.ref().getRemoteName().begin();
         it!=_sto.ref().getRemoteName().end();
         it++) {
      result+=QString::fromUtf8((*it).c_str()) + " ";
    }
    for (it=_sto.ref().getPurpose().begin();
         it!=_sto.ref().getPurpose().end();
         it++) {
      result+=QString::fromUtf8((*it).c_str()) + " ";
    }
    break;
  }

  case 4: { // value
    const AB_VALUE *v;

    v=_sto.ref().getValue();
    if (v) {
      result=QString::number(AB_Value_GetValue(v), 'f', 2);
      result+= " " + QString::fromUtf8(AB_Value_GetCurrency(v));
    }
    break;
  }
  case 5: { // lastExecutionDate
    const GWEN_TIME *ti;

    ti=_sto.ref().getLastExecutionDate();
    if (ti) {
      result=QString::number(GWEN_Time_Seconds(ti));
    }
    break;
  }
  default:
    result="";
    break;
  } // switch

  return result;
}



void StandingOrderListViewItem::setup(){
  widthChanged();
  setHeight(_ht);
}



void StandingOrderListViewItem::paintCell(QPainter * pnt,
                                          const QColorGroup & cg,
                                          int column,
                                          int width,
                                          int align){
  QSimpleRichText *p;
  QBrush br;

  if (column>=STANDINGORDER_LISTVIEW_COLUMNS) {
    DBG_WARN(0, "WARNING: Column out of range (%d)",column);
    return;
  }
  p=_cell[column];
  if (!p) {
    DBG_DEBUG(0, "StandingOrderListEntry::paintCell():Invalid pointer !!");
    return;
  }
  //pnt->eraseRect(pnt->viewport());
  if (isSelected())
    br=QBrush(QColor("light blue"));
    //br=cg.brush(QColorGroup::Highlight);
  else {
    if (!_colour.empty()) {
      br=QBrush(QColor(_colour.c_str()));
    }
    else {
      if (column & 1)
        br=QBrush(QColor("light yellow"));
        //br=cg.brush(QColorGroup::Light);
      else
        br=cg.brush(QColorGroup::Midlight);
    }
  }

  p->draw(pnt,
          listView()->itemMargin(),
          listView()->itemMargin(),
          QRect(0, 0, width, height()),
          cg, &br);
}



int StandingOrderListViewItem::width(const QFontMetrics &,
                                     const QListView *lv,
                                     int column) const {
  int w;

  if (column>=STANDINGORDER_LISTVIEW_COLUMNS) {
    DBG_DEBUG(0, "WARNING: Column out of range (%d)",column);
    return 0;
  }
  if (!_cell[column])
    return 0;

  w=_cell[column]->widthUsed()+lv->itemMargin()*2;
  return w;
}













StandingOrderListView::StandingOrderListView(QWidget *parent, const char *name)
:QListView(parent, name){
  setAllColumnsShowFocus(true);
  setShowSortIndicator(true);
  addColumn(QWidget::tr("Next Execution"),-1);
  addColumn(QWidget::tr("Institute"),-1);
  addColumn(QWidget::tr("Account"),-1);
  addColumn(QWidget::tr("Name/Purpose"),-1);
  addColumn(QWidget::tr("Value"),-1);
  addColumn(QWidget::tr("Final Execution"),-1);
  setColumnAlignment(5, Qt::AlignRight);
  header()->setTracking(false);
  QObject::connect(header(), SIGNAL(sizeChange(int, int, int)),
                   this, SLOT(slotHeaderChanged(int, int, int)));

}



StandingOrderListView::~StandingOrderListView(){
}



void StandingOrderListView::addStandingOrder(RefPointer<StandingOrder> t){
  StandingOrderListViewItem *entry;

  entry=new StandingOrderListViewItem(this, t);
}



void
StandingOrderListView::addStandingOrders(const std::list<RefPointer<StandingOrder> > &ts){
  std::list<RefPointer<StandingOrder> >::const_iterator it;

  for (it=ts.begin(); it!=ts.end(); it++) {
    addStandingOrder(*it);
  } /* for */
}



RefPointer<StandingOrder> StandingOrderListView::getCurrentStandingOrder() {
  StandingOrderListViewItem *entry;

  entry=dynamic_cast<StandingOrderListViewItem*>(currentItem());
  if (!entry) {
    DBG_DEBUG(0, "No item selected in list.");
    return 0;
  }
  return entry->getStandingOrder();
}



std::list<RefPointer<StandingOrder> > StandingOrderListView::getSelectedStandingOrders(){
  std::list<RefPointer<StandingOrder> > ts;
  StandingOrderListViewItem *entry;

  // Create an iterator and give the listview as argument
  QListViewItemIterator it(this);
  // iterate through all items of the listview
  for (;it.current();++it) {
    if (it.current()->isSelected()) {
      entry=dynamic_cast<StandingOrderListViewItem*>(it.current());
      if (entry)
        ts.push_back(entry->getStandingOrder());
    }
  } // for

  return ts;
}



void StandingOrderListView::slotHeaderChanged(int section,
                                         int oldSize,
                                         int newSize){
  StandingOrderListViewItem *entry;

  // Create an iterator and give the listview as argument
  QListViewItemIterator it(this);
  // iterate through all items of the listview
  for (;it.current();++it) {
    entry=dynamic_cast<StandingOrderListViewItem*>(it.current());
    if (entry) {
      entry->redrawItem();
    }
  } // for
}
































