/***************************************************************************
 $RCSfile: ts2po.c,v $
                             -------------------
    cvs         : $Id: ts2po.c,v 1.2 2005/02/21 12:36:00 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include <stdio.h>

#include <gwenhywfar/xml.h>
#include <gwenhywfar/debug.h>
#include <gwenhywfar/text.h>
#include <gwenhywfar/stringlist.h>




int writeXmlAs(GWEN_XMLNODE *n, const char *name, FILE *f,
	       GWEN_STRINGLIST *sl) {
  GWEN_XMLNODE *d;
  GWEN_BUFFER *tbuf;
  GWEN_BUFFER *destbuf;
  const char *p;

  tbuf=GWEN_Buffer_new(0, 256, 0, 1);
  d=GWEN_XMLNode_GetFirstData(n);
  while (d) {
    const char *s;

    s=GWEN_XMLNode_GetData(d);
    if (s) {
      if (GWEN_Text_UnescapeXmlToBuffer(s, tbuf)) {
        DBG_ERROR(0, "Bad characters in XML file");
        return -1;
      }
    }
    d=GWEN_XMLNode_GetNextData(d);
  } /* while */

  destbuf=GWEN_Buffer_new(0, GWEN_Buffer_GetUsedBytes(tbuf), 0, 1);
  p=GWEN_Buffer_GetStart(tbuf);
  while(*p) {
    if (*p=='\n') {
      GWEN_Buffer_AppendString(destbuf, "\\n");
    }
    else {
      if (*p=='"' || *p=='\'')
        GWEN_Buffer_AppendByte(destbuf, '\\');
      GWEN_Buffer_AppendByte(destbuf, *p);
    }
    p++;
  }

  if (sl) {
    if (GWEN_StringList_AppendString(sl, GWEN_Buffer_GetStart(destbuf),
				     0, 1)==0) {
      fprintf(stderr, "Double entry \"%s\", not adding.\n",
	      GWEN_Buffer_GetStart(destbuf));
      GWEN_Buffer_free(destbuf);
      GWEN_Buffer_free(tbuf);
      return 1;
    }
  }
  fprintf(f, "%s \"%s\"\n", name, GWEN_Buffer_GetStart(destbuf));
  GWEN_Buffer_free(destbuf);
  GWEN_Buffer_free(tbuf);
  return 0;
}



int main(int argc, char **argv) {
  GWEN_XMLNODE *nRoot;
  GWEN_XMLNODE *nContext;
  FILE *f;
  GWEN_STRINGLIST *sl;

  GWEN_Logger_SetLevel(GWEN_LOGDOMAIN, GWEN_LoggerLevelInfo);
  nRoot=GWEN_XMLNode_new(GWEN_XMLNodeTypeTag, "root");
  if (GWEN_XML_ReadFile(nRoot, "../../po/de.ts",
                        GWEN_XML_FLAGS_DEFAULT |
                        GWEN_XML_FLAGS_HANDLE_HEADERS|
                        GWEN_XML_FLAGS_KEEP_CNTRL)) {
    DBG_ERROR(0, "Could not read XML file.\n");
    return 2;
  }

  f=fopen("../../po/de.po", "w+");
  if (!f) {
    DBG_ERROR(0, "Could not create PO file.\n");
    return 2;
  }

  fprintf(f, "# automatically created by ts2po (c) 2005 Martin Preuss\n");
  fprintf(f, "msgid \"\"\n");
  fprintf(f, "msgstr \"\"\n");
  fprintf(f, "\"Project-Id-Version: de\\n\"\n"
	  "\"Report-Msgid-Bugs-To: EMAIL\\n\"\n"
	  "\"POT-Creation-Date: YYYY-MM-DD hh:mm+ZONE\\n\"\n"
	  "\"PO-Revision-Date: YYYY-MM-DD hh:mm+ZONE\\n\"\n"
	  "\"Last-Translator: TRANSLATOR\\n\"\n"
	  "\"Language-Team: LANG <ll@li.org>\\n\"\n"
	  "\"MIME-Version: 1.0\\n\"\n"
	  "\"Content-Type: text/plain; charset=UTF-8\\n\"\n"
	  "\"Content-Transfer-Encoding: 8bit\\n\"\n"
	  "\"X-Generator: ts2po\\n\"\n");
  fprintf(f, "\n");

  sl=GWEN_StringList_new();

  nContext=GWEN_XMLNode_FindFirstTag(nRoot, "ts", 0, 0);
  if (nContext)
    nContext=GWEN_XMLNode_FindFirstTag(nContext, "context", 0, 0);
  while(nContext) {
    GWEN_XMLNODE *nMessage;

    nMessage=GWEN_XMLNode_FindFirstTag(nContext, "message", 0, 0);
    while(nMessage) {
      GWEN_XMLNODE *nSource;

      nSource=GWEN_XMLNode_FindFirstTag(nMessage, "source", 0, 0);
      if (nSource) {
	GWEN_XMLNODE *nTrans;
        int rv;

	fprintf(f, "# message\n");
	rv=writeXmlAs(nSource, "msgid", f, sl);
        if (rv==-1)
	  return 2;
	if (rv==0) {
	  nTrans=GWEN_XMLNode_FindFirstTag(nMessage, "translation", 0, 0);
	  if (nTrans) {
	    if (writeXmlAs(nTrans, "msgstr", f, 0))
	      return 2;
	  }
	  else {
	    fprintf(f, "msgstr \"\"\n");
	  }
	}
	fprintf(f, "\n");
      }

      nMessage=GWEN_XMLNode_FindNextTag(nMessage, "message", 0, 0);
    } /* while */

    nContext=GWEN_XMLNode_FindNextTag(nContext, "context", 0, 0);
  }
  GWEN_StringList_free(sl);

  if (fclose(f)) {
    DBG_ERROR(0, "Could not close PO file");
    return 3;
  }
  return 0;
}



