/***************************************************************************
  main.cpp
  -------------------
  A brewing recipe calculator
  -------------------
  Copyright (c) 1999-2007 David Johnson <david@usermode.org>
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
 
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
 
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
 
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
****************************************************************************/

#include <cstdlib>
#include <iostream>

#include <QApplication>
#include <QMainWindow>
#include <QStringList>

#if defined(Q_WS_MACX)
extern void qt_mac_set_menubar_icons(bool enable);
#endif

#include "qbrew.h"
#include "resource.h"

using namespace std;
using namespace Resource;

//////////////////////////////////////////////////////////////////////////////
// doversion()
// -----------
// Print out copyright and version info to stdout

void doversion()
{
    cout << PACKAGE << ' ' << VERSION << '\n';
    cout << qPrintable(DESCRIPTION) << '\n';
    cout << qPrintable(COPYRIGHT);
    cout << ' ' << qPrintable(AUTHOR);
    cout << " <" << qPrintable(AUTHOR_EMAIL) << ">";
    cout << endl;
}

//////////////////////////////////////////////////////////////////////////////
// dohelp()
// --------
// Print out help info to stdout

void dohelp()
{
    cout << "Usage: " << PACKAGE << " [options] [file]\n";
    cout << qPrintable(DESCRIPTION) << '\n';

    // arguments
    cout << "\nArguments:\n";
    cout << "    file                  File to open\n";

    // general options
    cout << "\nOptions\n";
    cout << "    --help                Print the command line options.\n";
    cout << "    --version             Print the application version.\n";
    cout << endl;
}

//////////////////////////////////////////////////////////////////////////////
// doargs()
// --------
// Process the arguments that QApplication doesn't take care of

QString doargs(QStringList arguments)
{
    QString arg;
    for (int n=1; n<arguments.count(); ++n) {
        arg = arguments.at(n);
        if ((arg == "-h")  || (arg == "-help") ||
            (arg == "--help")) {
            dohelp();
            exit(0);
        } else if ((arg == "-v") || (arg == "-version") ||
                   (arg == "--version")) {
            doversion();
            exit(0);
        } else if (arg[0] == '-') {
            // no other valid options
            cout << "Invalid parameter \"" << qPrintable(arg) << "\"\n";
            dohelp();
            exit(1);
        } else {
            // it must be a filename
            return arg;
        }
    }
    return (DEFAULT_FILE);
}

//////////////////////////////////////////////////////////////////////////////
// main()
// ------
// Entry point of application

int main(int argc, char **argv)
{
    Q_INIT_RESOURCE(qbrew);

    QApplication app(argc, argv);

#if defined(Q_WS_MACX)
    // disable icons on Mac menus (as is customary)
    qt_mac_set_menubar_icons(false);
#endif

    // check for additional command line arguments
    QString filename = doargs(app.arguments());

    QBrew* mainwindow = QBrew::instance();
    mainwindow->initialize(filename);
    mainwindow->show();

    app.installEventFilter(mainwindow); // for handling file open events

    return app.exec();
}
