/***************************************************************************
  controller.h
  -------------------
  Control class for QBrew
  -------------------
  Copyright 1999-2002, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  3. Neither the name of the author nor the names of the contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***************************************************************************/

#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <qmainwindow.h>

#include "resource.h"

class QAction;
class QPopupMenu;
class QToolBar;

class Model;
class Preferences;
class View;

/**
 * The Controller class for QBrew. The controller is the "command" interface
 * to the application, and contains the frame window and main menu. This is
 * a singleton class.
 */
class Controller : public QMainWindow {
    Q_OBJECT
public:
    // Return pointer to the controller.
    static Controller *instance();
    // Initialize the controller
    void initialize(const QString &filename = "");

    // return application preferences
    Preferences *preferences();
    // return recipe as an ascii string
    // TODO: put in model?
    QString getRecipeText();
    
    // return out the base dir for the help documents
    QString docBase();
    // return out the base dir for the data files
    QString dataBase();

public slots:
    // generate a new document
    void fileNew();
    // open a document
    void fileOpen();
    // save a document
    void fileSave();
    // save a document under a different filename
    void fileSaveAs();
    // print the document
    void filePrint();
    // exits the application
    void fileQuit();
    
    // toggle the toolbar
    void optionsToolbar();
    // toggle the statusbar
    void optionsStatusbar();
    // display the setup dialog
    void optionsSetup();
    // save application settings
    void optionsSaveSetup();

    // Popup the hydrometer correction tool
    void toolsHydrometer();

    // displays help contents
    void helpContents();
    // displays primer contents
    void helpPrimer();
    // shows an about dialog for QBrew
    void helpAbout();

    // received if view widgets have changed
    void documentModified();

private:
    // Private constructor.
    Controller();
    // Private destructor
    ~Controller();

    // initialize actions
    void initActions();
    // initialize the menubar
    void initMenuBar();
    // initialize the toolbar
    void initToolBar();
    // initialize the statusbar
    void initStatusBar();

    // query user to save the current file
    int querySave();

private:
    friend class nofriendsatall; // to avoid warnings
    static Controller *instance_;

    Model *model_;
    View *view_;

    Preferences *preferences_;
    QString filename_;
    bool newflag_;

    QAction *filenew_;
    QAction *fileopen_;
    QAction *filesave_;
    QAction *filesaveas_;
    QAction *fileprint_;
    QAction *filequit_;
    QAction *optionstoolbar_;
    QAction *optionsstatusbar_;
    QAction *optionssetup_;
    QAction *optionssavesetup_;
    QAction *toolhydrometer_;
    QAction *helpcontents_;
    QAction *helpprimer_;
    QAction *helpabout_;
    QAction *helpcontext_;

    QPopupMenu* filemenu_;
    QPopupMenu* optionsmenu_;
    QPopupMenu* toolsmenu_;
    QPopupMenu* helpmenu_;
    QToolBar* toolbar_;

    QString units_;
};

// Inlined Methods ///////////////////////////////////////////////////////////

inline Preferences *Controller::preferences() { return preferences_; }

#endif // CONTROLLER_H
